/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;

public class ServletRequestAttribute
implements ExchangeAttribute {
    private final String attributeName;

    public ServletRequestAttribute(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Object result;
        ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (result = context.getServletRequest().getAttribute(this.attributeName)) != null) {
            return result.toString();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null) {
            context.getServletRequest().setAttribute(this.attributeName, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Servlet request attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{r,") && token.endsWith("}")) {
                String attributeName = token.substring(4, token.length() - 1);
                return new ServletRequestAttribute(attributeName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

