/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.UndertowLogger;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.server.handlers.encoding.ContentEncodedResource;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.server.handlers.resource.CachedResource;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ImmediateConduitFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class ContentEncodedResourceManager {
    private final Path encodedResourcesRoot;
    private final CachingResourceManager encoded;
    private final ContentEncodingRepository contentEncodingRepository;
    private final int minResourceSize;
    private final int maxResourceSize;
    private final Predicate encodingAllowed;
    private final ConcurrentMap<LockKey, Object> fileLocks = new ConcurrentHashMap<LockKey, Object>();

    public ContentEncodedResourceManager(Path encodedResourcesRoot, CachingResourceManager encodedResourceManager, ContentEncodingRepository contentEncodingRepository, int minResourceSize, int maxResourceSize, Predicate encodingAllowed) {
        this.encodedResourcesRoot = encodedResourcesRoot;
        this.encoded = encodedResourceManager;
        this.contentEncodingRepository = contentEncodingRepository;
        this.minResourceSize = minResourceSize;
        this.maxResourceSize = maxResourceSize;
        this.encodingAllowed = encodingAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentEncodedResource getResource(Resource resource, HttpServerExchange exchange) throws IOException {
        FileChannel sourceFileChannel;
        FileChannel targetFileChannel;
        LockKey key;
        String newPath;
        EncodingMapping encoding;
        Path file;
        block13: {
            ContentEncodedResource contentEncodedResource;
            String path = resource.getPath();
            file = resource.getFilePath();
            if (file == null) {
                return null;
            }
            if (this.minResourceSize > 0 && resource.getContentLength() < (long)this.minResourceSize || this.maxResourceSize > 0 && resource.getContentLength() > (long)this.maxResourceSize || this.encodingAllowed != null && !this.encodingAllowed.resolve(exchange)) {
                return null;
            }
            AllowedContentEncodings encodings = this.contentEncodingRepository.getContentEncodings(exchange);
            if (encodings == null || encodings.isNoEncodingsAllowed()) {
                return null;
            }
            encoding = encodings.getEncoding();
            if (encoding == null || encoding.getName().equals("identity")) {
                return null;
            }
            newPath = path + ".undertow.encoding." + encoding.getName();
            CachedResource preCompressed = this.encoded.getResource(newPath);
            if (preCompressed != null) {
                return new ContentEncodedResource(preCompressed, encoding.getName());
            }
            key = new LockKey(path, encoding.getName());
            if (this.fileLocks.putIfAbsent(key, this) != null) {
                return null;
            }
            targetFileChannel = null;
            sourceFileChannel = null;
            try {
                preCompressed = this.encoded.getResource(newPath);
                if (preCompressed == null) break block13;
                contentEncodedResource = new ContentEncodedResource(preCompressed, encoding.getName());
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(targetFileChannel);
                IoUtils.safeClose(sourceFileChannel);
                this.fileLocks.remove(key);
                throw throwable;
            }
            IoUtils.safeClose(targetFileChannel);
            IoUtils.safeClose(sourceFileChannel);
            this.fileLocks.remove(key);
            return contentEncodedResource;
        }
        Path finalTarget = this.encodedResourcesRoot.resolve(newPath);
        Path tempTarget = this.encodedResourcesRoot.resolve(newPath);
        OutputStream tmp = Files.newOutputStream(tempTarget, new OpenOption[0]);
        try {
            tmp.close();
        }
        finally {
            IoUtils.safeClose((Closeable)tmp);
        }
        targetFileChannel = FileChannel.open(tempTarget, StandardOpenOption.READ, StandardOpenOption.WRITE);
        sourceFileChannel = FileChannel.open(file, StandardOpenOption.READ);
        StreamSinkConduit conduit = encoding.getEncoding().getResponseWrapper().wrap(new ImmediateConduitFactory<FileConduitTarget>(new FileConduitTarget(targetFileChannel, exchange)), exchange);
        ConduitStreamSinkChannel targetChannel = new ConduitStreamSinkChannel(null, conduit);
        long transferred = sourceFileChannel.transferTo(0L, resource.getContentLength(), targetChannel);
        targetChannel.shutdownWrites();
        Channels.flushBlocking(targetChannel);
        if (transferred != resource.getContentLength()) {
            UndertowLogger.REQUEST_LOGGER.failedToWritePreCachedFile();
        }
        Files.move(tempTarget, finalTarget, new CopyOption[0]);
        this.encoded.invalidate(newPath);
        CachedResource encodedResource = this.encoded.getResource(newPath);
        ContentEncodedResource contentEncodedResource = new ContentEncodedResource(encodedResource, encoding.getName());
        IoUtils.safeClose((Closeable)targetFileChannel);
        IoUtils.safeClose((Closeable)sourceFileChannel);
        this.fileLocks.remove(key);
        return contentEncodedResource;
    }

    private static final class FileConduitTarget
    implements StreamSinkConduit {
        private final FileChannel fileChannel;
        private final HttpServerExchange exchange;
        private WriteReadyHandler writeReadyHandler;
        private boolean writesResumed = false;

        private FileConduitTarget(FileChannel fileChannel, HttpServerExchange exchange) {
            this.fileChannel = fileChannel;
            this.exchange = exchange;
        }

        @Override
        public long transferFrom(FileChannel fileChannel, long l, long l2) throws IOException {
            return this.fileChannel.transferFrom(fileChannel, l, l2);
        }

        @Override
        public long transferFrom(StreamSourceChannel streamSourceChannel, long l, ByteBuffer byteBuffer) throws IOException {
            return IoUtils.transfer(streamSourceChannel, l, byteBuffer, this.fileChannel);
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.fileChannel.write(byteBuffer);
        }

        @Override
        public long write(ByteBuffer[] byteBuffers, int i, int i2) throws IOException {
            return this.fileChannel.write(byteBuffers, i, i2);
        }

        @Override
        public int writeFinal(ByteBuffer src) throws IOException {
            return Conduits.writeFinalBasic(this, src);
        }

        @Override
        public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return Conduits.writeFinalBasic(this, srcs, offset, length);
        }

        @Override
        public void terminateWrites() throws IOException {
            this.fileChannel.close();
        }

        @Override
        public boolean isWriteShutdown() {
            return !this.fileChannel.isOpen();
        }

        @Override
        public void resumeWrites() {
            this.wakeupWrites();
        }

        @Override
        public void suspendWrites() {
            this.writesResumed = false;
        }

        @Override
        public void wakeupWrites() {
            if (this.writeReadyHandler != null) {
                this.writesResumed = true;
                while (this.writesResumed && this.writeReadyHandler != null) {
                    this.writeReadyHandler.writeReady();
                }
            }
        }

        @Override
        public boolean isWriteResumed() {
            return this.writesResumed;
        }

        @Override
        public void awaitWritable() throws IOException {
        }

        @Override
        public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public XnioIoThread getWriteThread() {
            return this.exchange.getIoThread();
        }

        @Override
        public void setWriteReadyHandler(WriteReadyHandler writeReadyHandler) {
            this.writeReadyHandler = writeReadyHandler;
        }

        @Override
        public void truncateWrites() throws IOException {
            this.fileChannel.close();
        }

        @Override
        public boolean flush() throws IOException {
            return true;
        }

        @Override
        public XnioWorker getWorker() {
            return this.exchange.getConnection().getWorker();
        }
    }

    private final class LockKey {
        private final String path;
        private final String encoding;

        private LockKey(String path, String encoding) {
            this.path = path;
            this.encoding = encoding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockKey lockKey = (LockKey)o;
            if (this.encoding != null ? !this.encoding.equals(lockKey.encoding) : lockKey.encoding != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(lockKey.path) : lockKey.path != null);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
            return result;
        }
    }
}

