/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="UT")
public interface UndertowServletLogger
extends BasicLogger {
    public static final UndertowServletLogger ROOT_LOGGER = Logger.getMessageLogger(UndertowServletLogger.class, UndertowServletLogger.class.getPackage().getName());
    public static final UndertowServletLogger REQUEST_LOGGER = Logger.getMessageLogger(UndertowServletLogger.class, UndertowServletLogger.class.getPackage().getName() + ".request");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15000, value="IOException handling request")
    public void ioExceptionHandingRequest(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15001, value="ServletException handling request")
    public void servletExceptionHandlingRequest(@Cause ServletException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15002, value="Stopping servlet %s due to permanent unavailability")
    public void stoppingServletDueToPermanentUnavailability(String var1, @Cause UnavailableException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15003, value="Stopping servlet %s till %s due to temporary unavailability")
    public void stoppingServletUntilDueToTemporaryUnavailability(String var1, Date var2, @Cause UnavailableException var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15004, value="Malformed URL exception reading resource %s")
    public void malformedUrlException(String var1, @Cause MalformedURLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15005, value="Error invoking method %s on listener %s")
    public void errorInvokingListener(String var1, Class<?> var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15006, value="IOException dispatching async event")
    public void ioExceptionDispatchingAsyncEvent(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15007, value="Stack trace on error enabled for deployment %s, please do not enable for production use")
    public void servletStackTracesAll(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15008, value="Failed to load development mode persistent sessions")
    public void failedtoLoadPersistentSessions(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15009, value="Failed to persist session attribute %s with value %s for session %s")
    public void failedToPersistSessionAttribute(String var1, Object var2, String var3, @Cause Exception var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15010, value="Failed to persist sessions")
    public void failedToPersistSessions(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15011, value="Non standard filter mapping '*' for filter %s. Portable application should use '/*' instead.")
    public void nonStandardFilterMapping(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15012, value="Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.")
    public void errorGeneratingErrorPage(String var1, Object var2, int var3, @Cause Throwable var4);

    @Message(id=15013, value="Error opening rewrite configuration")
    public String errorOpeningRewriteConfiguration();

    @Message(id=15014, value="Error reading rewrite configuration")
    @LogMessage(level=Logger.Level.ERROR)
    public void errorReadingRewriteConfiguration(@Cause IOException var1);

    @Message(id=15015, value="Error reading rewrite configuration: %s")
    public IllegalArgumentException invalidRewriteConfiguration(String var1);

    @Message(id=15016, value="Invalid rewrite map class: %s")
    public IllegalArgumentException invalidRewriteMap(String var1);

    @Message(id=15017, value="Error reading rewrite flags in line %s as %s")
    public IllegalArgumentException invalidRewriteFlags(String var1, String var2);

    @Message(id=15018, value="Error reading rewrite flags in line %s")
    public IllegalArgumentException invalidRewriteFlags(String var1);
}

