/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;

public class SessionContainer {
    private Runnable doneTask;
    private volatile int waiterCount;
    private final Set<Session> openSessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<Session> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOpenSession(Session session) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            this.openSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpenSession(Session session) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            this.openSessions.remove(session);
            if (this.waiterCount > 0 && this.openSessions.isEmpty()) {
                this.notifyAll();
            }
            if (this.doneTask != null) {
                this.doneTask.run();
                this.doneTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitClose(long timeout) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            if (this.openSessions.isEmpty()) {
                return;
            }
            ++this.waiterCount;
            long end = System.currentTimeMillis() + timeout;
            try {
                while (System.currentTimeMillis() < end) {
                    this.wait(end - System.currentTimeMillis());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                --this.waiterCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed(Runnable done) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            if (this.openSessions.isEmpty()) {
                done.run();
            } else {
                this.doneTask = done;
            }
        }
    }
}

