/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.AggregateConnectorStatistics;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.util.ALPN;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.SslConnection;

class JDK9AlpnOpenListener
implements ChannelListener<StreamConnection>,
AlpnOpenListener.AlpnDelegateListener {
    private final ByteBufferPool bufferPool;
    private final Map<String, ListenerEntry> listeners = new HashMap<String, ListenerEntry>();
    private final String fallbackProtocol;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;

    JDK9AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this.bufferPool = bufferPool;
        this.fallbackProtocol = fallbackProtocol;
        if (fallbackProtocol != null && fallbackListener != null) {
            this.addProtocol(fallbackProtocol, fallbackListener, 0);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
        this.undertowOptions = undertowOptions;
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(this.rootHandler);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            ArrayList<ConnectorStatistics> stats = new ArrayList<ConnectorStatistics>();
            for (Map.Entry<String, ListenerEntry> l : this.listeners.entrySet()) {
                ConnectorStatistics c = l.getValue().listener.getConnectorStatistics();
                if (c == null) continue;
                stats.add(c);
            }
            return new AggregateConnectorStatistics(stats.toArray(new ConnectorStatistics[stats.size()]));
        }
        return null;
    }

    @Override
    public void addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.listeners.put(name, new ListenerEntry(listener, weight, name));
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        SSLEngine sslEngine = UndertowXnioSsl.getSslEngine((SslConnection)channel);
        AlpnConnectionListener potentialConnection = new AlpnConnectionListener(channel, sslEngine);
        channel.getSourceChannel().setReadListener(potentialConnection);
        String[] protocols = new String[this.listeners.size()];
        ArrayList<ListenerEntry> entries = new ArrayList<ListenerEntry>(this.listeners.values());
        Collections.sort(entries);
        for (int i = 0; i < entries.size(); ++i) {
            protocols[i] = ((ListenerEntry)entries.get((int)i)).protocol;
        }
        try {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            ALPN.JDK_9_ALPN_METHODS.setApplicationProtocols().invoke((Object)sslParameters, new Object[]{protocols});
            sslEngine.setSSLParameters(sslParameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            UndertowLogger.ROOT_LOGGER.alpnConnectionFailed(e);
            IoUtils.safeClose((Closeable)channel);
        }
        potentialConnection.handleEvent(channel.getSourceChannel());
    }

    private class AlpnConnectionListener
    implements ChannelListener<StreamSourceChannel> {
        private final StreamConnection channel;
        private final SSLEngine sslEngine;

        private AlpnConnectionListener(StreamConnection channel, SSLEngine sslEngine) {
            this.channel = channel;
            this.sslEngine = sslEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel source) {
            PooledByteBuffer buffer = JDK9AlpnOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read(buffer.getBuffer())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    buffer.getBuffer().flip();
                    String selected = (String)ALPN.JDK_9_ALPN_METHODS.getApplicationProtocol().invoke((Object)this.sslEngine, new Object[0]);
                    if (selected != null) {
                        DelegateOpenListener listener;
                        if (selected.isEmpty()) {
                            if (JDK9AlpnOpenListener.this.fallbackProtocol == null) {
                                UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                                IoUtils.safeClose((Closeable)this.channel);
                                return;
                            }
                            listener = ((ListenerEntry)((JDK9AlpnOpenListener)JDK9AlpnOpenListener.this).listeners.get((Object)((JDK9AlpnOpenListener)JDK9AlpnOpenListener.this).fallbackProtocol)).listener;
                        } else {
                            listener = ((ListenerEntry)((JDK9AlpnOpenListener)JDK9AlpnOpenListener.this).listeners.get((Object)selected)).listener;
                        }
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res > 0) {
                        if (JDK9AlpnOpenListener.this.fallbackProtocol == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        DelegateOpenListener listener = ((ListenerEntry)((JDK9AlpnOpenListener)JDK9AlpnOpenListener.this).listeners.get((Object)((JDK9AlpnOpenListener)JDK9AlpnOpenListener.this).fallbackProtocol)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                UndertowLogger.ROOT_LOGGER.alpnConnectionFailed(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.close();
                }
            }
        }
    }

    private static class ListenerEntry
    implements Comparable<ListenerEntry> {
        final DelegateOpenListener listener;
        final int weight;
        final String protocol;

        ListenerEntry(DelegateOpenListener listener, int weight, String protocol) {
            this.listener = listener;
            this.weight = weight;
            this.protocol = protocol;
        }

        @Override
        public int compareTo(ListenerEntry o) {
            return -Integer.compare(this.weight, o.weight);
        }
    }
}

