/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.PathTemplateMatcher;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerContainer;
import org.xnio.StreamConnection;

public class JsrWebSocketFilter
implements Filter {
    private WebSocketConnectionCallback callback;
    private PathTemplateMatcher<ServerWebSocketContainer.WebSocketHandshakeHolder> pathTemplateMatcher;
    private Set<WebSocketChannel> peerConnections;
    private ServerWebSocketContainer container;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
        this.container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        this.container.deploymentComplete();
        this.pathTemplateMatcher = new PathTemplateMatcher();
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)filterConfig.getServletContext().getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        for (ConfiguredServerEndpoint endpoint : this.container.getConfiguredServerEndpoints()) {
            if (info == null || info.getExtensions().isEmpty()) {
                this.pathTemplateMatcher.add(endpoint.getPathTemplate(), ServerWebSocketContainer.handshakes(endpoint));
                continue;
            }
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), ServerWebSocketContainer.handshakes(endpoint, info.getExtensions()));
        }
        this.callback = new EndpointSessionHandler(this.container);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            PathTemplateMatcher.PathMatchResult<ServerWebSocketContainer.WebSocketHandshakeHolder> matchResult;
            final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp, this.peerConnections);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : matchResult.getValue().handshakes) {
                    if (!method.matches(facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker != null) {
                    if (this.container.isClosed()) {
                        resp.sendError(503);
                        return;
                    }
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, matchResult.getParameters());
                    facade.putAttachment(HandshakeUtil.PRINCIPAL, req.getUserPrincipal());
                    final Handshake selected = handshaker;
                    facade.upgradeChannel(new HttpUpgradeListener(){

                        @Override
                        public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                            WebSocketChannel channel = selected.createChannel(facade, streamConnection, facade.getBufferPool());
                            JsrWebSocketFilter.this.peerConnections.add(channel);
                            JsrWebSocketFilter.this.callback.onConnect(facade, channel);
                        }
                    });
                    handshaker.handshake(facade);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

