/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.chat;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;

@UndertowExample(value="Chat")
public class ChatServer {
    public static void main(String[] args) {
        System.out.println("To see chat in action is to open two different browsers and point them at http://localhost:8080");
        Undertow server = Undertow.builder().addHttpListener(8080, "localhost").setHandler(Handlers.path().addPrefixPath("/myapp", Handlers.websocket(new WebSocketConnectionCallback(){

            @Override
            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                channel.getReceiveSetter().set(new AbstractReceiveListener(){

                    @Override
                    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
                        String messageData = message.getData();
                        for (WebSocketChannel session : channel.getPeerConnections()) {
                            WebSockets.sendText(messageData, session, null);
                        }
                    }
                });
                channel.resumeReceives();
            }
        })).addPrefixPath("/", Handlers.resource(new ClassPathResourceManager(ChatServer.class.getClassLoader(), ChatServer.class.getPackage())).addWelcomeFiles("index.html"))).build();
        server.start();
    }
}

