/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedServlets;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.ServletContextImpl;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class DeploymentImpl
implements Deployment {
    private final DeploymentManager deploymentManager;
    private final DeploymentInfo deploymentInfo;
    private final ServletContainer servletContainer;
    private final List<Lifecycle> lifecycleObjects = new ArrayList<Lifecycle>();
    private final ServletPathMatches servletPaths;
    private final ManagedServlets servlets;
    private final ManagedFilters filters;
    private volatile ApplicationListeners applicationListeners;
    private volatile ServletContextImpl servletContext;
    private volatile ServletInitialHandler servletHandler;
    private volatile HttpHandler initialHandler;
    private volatile ErrorPages errorPages;
    private volatile Map<String, String> mimeExtensionMappings;
    private volatile SessionManager sessionManager;
    private volatile Charset defaultCharset;
    private volatile List<AuthenticationMechanism> authenticationMechanisms;
    private volatile List<ThreadSetupHandler> threadSetupActions;

    public DeploymentImpl(DeploymentManager deploymentManager, DeploymentInfo deploymentInfo, ServletContainer servletContainer) {
        this.deploymentManager = deploymentManager;
        this.deploymentInfo = deploymentInfo;
        this.servletContainer = servletContainer;
        this.servletPaths = new ServletPathMatches(this);
        this.servlets = new ManagedServlets(this, this.servletPaths);
        this.filters = new ManagedFilters(this, this.servletPaths);
    }

    @Override
    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    @Override
    public ManagedServlets getServlets() {
        return this.servlets;
    }

    @Override
    public ManagedFilters getFilters() {
        return this.filters;
    }

    void setApplicationListeners(ApplicationListeners applicationListeners) {
        this.applicationListeners = applicationListeners;
    }

    void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    @Override
    public ApplicationListeners getApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    @Override
    public HttpHandler getHandler() {
        return this.initialHandler;
    }

    public void setInitialHandler(HttpHandler initialHandler) {
        this.initialHandler = initialHandler;
    }

    void setServletHandler(ServletInitialHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    void addLifecycleObjects(Collection<Lifecycle> objects) {
        this.lifecycleObjects.addAll(objects);
    }

    void addLifecycleObjects(Lifecycle ... objects) {
        this.lifecycleObjects.addAll(Arrays.asList(objects));
    }

    void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public List<Lifecycle> getLifecycleObjects() {
        return Collections.unmodifiableList(this.lifecycleObjects);
    }

    @Override
    public ServletPathMatches getServletPaths() {
        return this.servletPaths;
    }

    void setThreadSetupActions(List<ThreadSetupHandler> threadSetupActions) {
        this.threadSetupActions = threadSetupActions;
    }

    public <C, T> ThreadSetupHandler.Action<C, T> createThreadSetupAction(ThreadSetupHandler.Action<C, T> target) {
        ThreadSetupHandler.Action<C, T> ret = target;
        for (ThreadSetupHandler wrapper : this.threadSetupActions) {
            ret = wrapper.create(ret);
        }
        return ret;
    }

    @Override
    public ThreadSetupAction getThreadSetupAction() {
        return new ThreadSetupAction(){

            @Override
            public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                final ClassLoader old = SecurityActions.getContextClassLoader();
                SecurityActions.setContextClassLoader(DeploymentImpl.this.deploymentInfo.getClassLoader());
                final ServletRequestContext oldSc = ServletRequestContext.current();
                if (exchange != null) {
                    ServletRequestContext sc = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    SecurityActions.setCurrentRequestContext(sc);
                }
                return new ThreadSetupAction.Handle(){

                    @Override
                    public void tearDown() {
                        SecurityActions.setContextClassLoader(old);
                        SecurityActions.setCurrentRequestContext(oldSc);
                    }
                };
            }
        };
    }

    @Override
    public ErrorPages getErrorPages() {
        return this.errorPages;
    }

    public void setErrorPages(ErrorPages errorPages) {
        this.errorPages = errorPages;
    }

    @Override
    public Map<String, String> getMimeExtensionMappings() {
        return this.mimeExtensionMappings;
    }

    public void setMimeExtensionMappings(Map<String, String> mimeExtensionMappings) {
        this.mimeExtensionMappings = Collections.unmodifiableMap(new HashMap<String, String>(mimeExtensionMappings));
    }

    @Override
    public ServletDispatcher getServletDispatcher() {
        return this.servletHandler;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Executor getExecutor() {
        return this.deploymentInfo.getExecutor();
    }

    @Override
    public Executor getAsyncExecutor() {
        return this.deploymentInfo.getAsyncExecutor();
    }

    @Override
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setAuthenticationMechanisms(List<AuthenticationMechanism> authenticationMechanisms) {
        this.authenticationMechanisms = authenticationMechanisms;
    }

    @Override
    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        return this.authenticationMechanisms;
    }

    @Override
    public DeploymentManager.State getDeploymentState() {
        return this.deploymentManager.getState();
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    void destroy() {
        this.getApplicationListeners().contextDestroyed();
        this.getApplicationListeners().stop();
        if (this.servletContext != null) {
            this.servletContext.destroy();
        }
        this.servletContext = null;
    }
}

