/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientStatistics;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.client.http2.Http2ClientExchange;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2GoAwayStreamSourceChannel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingStreamSourceChannel;
import io.undertow.protocols.http2.Http2PushPromiseStreamSourceChannel;
import io.undertow.protocols.http2.Http2RstStreamStreamSourceChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.NetworkUtils;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class Http2ClientConnection
implements ClientConnection {
    private final Http2Channel http2Channel;
    private final ChannelListener.SimpleSetter<ClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final Map<Integer, Http2ClientExchange> currentExchanges = new ConcurrentHashMap<Integer, Http2ClientExchange>();
    private boolean initialUpgradeRequest;
    private final String defaultHost;
    private final ClientStatistics clientStatistics;
    private final List<ChannelListener<ClientConnection>> closeListeners = new CopyOnWriteArrayList<ChannelListener<ClientConnection>>();
    private final boolean secure;

    public Http2ClientConnection(Http2Channel http2Channel, boolean initialUpgradeRequest, String defaultHost, ClientStatistics clientStatistics, boolean secure) {
        this.http2Channel = http2Channel;
        this.defaultHost = defaultHost;
        this.clientStatistics = clientStatistics;
        this.secure = secure;
        http2Channel.getReceiveSetter().set(new Http2ReceiveListener());
        http2Channel.resumeReceives();
        http2Channel.addCloseTask(new ChannelListener<Http2Channel>(){

            @Override
            public void handleEvent(Http2Channel channel) {
                ChannelListeners.invokeChannelListener(Http2ClientConnection.this, Http2ClientConnection.this.closeSetter.get());
                for (ChannelListener listener : Http2ClientConnection.this.closeListeners) {
                    listener.handleEvent(Http2ClientConnection.this);
                }
            }
        });
        this.initialUpgradeRequest = initialUpgradeRequest;
    }

    public Http2ClientConnection(Http2Channel http2Channel, ClientCallback<ClientExchange> upgradeReadyCallback, ClientRequest clientRequest, String defaultHost, ClientStatistics clientStatistics, boolean secure) {
        this.http2Channel = http2Channel;
        this.defaultHost = defaultHost;
        this.clientStatistics = clientStatistics;
        this.secure = secure;
        http2Channel.getReceiveSetter().set(new Http2ReceiveListener());
        http2Channel.resumeReceives();
        http2Channel.addCloseTask(new ChannelListener<Http2Channel>(){

            @Override
            public void handleEvent(Http2Channel channel) {
                ChannelListeners.invokeChannelListener(Http2ClientConnection.this, Http2ClientConnection.this.closeSetter.get());
            }
        });
        this.initialUpgradeRequest = false;
        Http2ClientExchange exchange = new Http2ClientExchange(this, null, clientRequest);
        exchange.setResponseListener(upgradeReadyCallback);
        this.currentExchanges.put(1, exchange);
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        Http2HeadersStreamSinkChannel sinkChannel;
        Integer port;
        Boolean proto;
        String host;
        request.getRequestHeaders().put(Http2Channel.METHOD, request.getMethod().toString());
        boolean connectRequest = request.getMethod().equals(Methods.CONNECT);
        if (!connectRequest) {
            request.getRequestHeaders().put(Http2Channel.PATH, request.getPath());
            request.getRequestHeaders().put(Http2Channel.SCHEME, this.secure ? "https" : "http");
        }
        if ((host = request.getRequestHeaders().getFirst(Headers.HOST)) != null) {
            request.getRequestHeaders().put(Http2Channel.AUTHORITY, host);
        } else {
            request.getRequestHeaders().put(Http2Channel.AUTHORITY, this.defaultHost);
        }
        request.getRequestHeaders().remove(Headers.HOST);
        boolean hasContent = true;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                return;
            }
        } else if (transferEncodingString == null && !connectRequest) {
            hasContent = false;
        }
        request.getRequestHeaders().remove(Headers.CONNECTION);
        request.getRequestHeaders().remove(Headers.KEEP_ALIVE);
        request.getRequestHeaders().remove(Headers.TRANSFER_ENCODING);
        String peer = request.getAttachment(ProxiedRequestAttachments.REMOTE_HOST);
        if (peer != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, peer);
        }
        if ((proto = request.getAttachment(ProxiedRequestAttachments.IS_SSL)) == null || !proto.booleanValue()) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, "http");
        } else {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, "https");
        }
        String hn = request.getAttachment(ProxiedRequestAttachments.SERVER_NAME);
        if (hn != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, NetworkUtils.formatPossibleIpv6Address(hn));
        }
        if ((port = request.getAttachment(ProxiedRequestAttachments.SERVER_PORT)) != null) {
            request.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port.intValue());
        }
        try {
            sinkChannel = this.http2Channel.createStream(request.getRequestHeaders());
        }
        catch (IOException e) {
            clientCallback.failed(e);
            return;
        }
        Http2ClientExchange exchange = new Http2ClientExchange(this, sinkChannel, request);
        this.currentExchanges.put(sinkChannel.getStreamId(), exchange);
        if (clientCallback != null) {
            clientCallback.completed(exchange);
        }
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            Http2ClientConnection.this.handleError(exception);
                        }
                    }));
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        } else if (!sinkChannel.isWriteResumed()) {
            try {
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            try {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                            }
                            catch (IOException e) {
                                Http2ClientConnection.this.handleError(e);
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)this);
        for (Map.Entry<Integer, Http2ClientExchange> entry : this.currentExchanges.entrySet()) {
            try {
                entry.getValue().failed(e);
            }
            catch (Exception ex) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
            }
        }
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.http2Channel.getBufferPool();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.http2Channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.http2Channel.getPeerAddress(type);
    }

    @Override
    public ChannelListener.Setter<? extends ClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.http2Channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.http2Channel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.http2Channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.http2Channel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.http2Channel.isOpen() && !this.http2Channel.isPeerGoneAway() && !this.http2Channel.isThisGoneAway();
    }

    @Override
    public void close() throws IOException {
        try {
            this.http2Channel.sendGoAway(0);
        }
        finally {
            for (Map.Entry<Integer, Http2ClientExchange> entry : this.currentExchanges.entrySet()) {
                entry.getValue().failed(new ClosedChannelException());
            }
            this.currentExchanges.clear();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    @Override
    public boolean isUpgraded() {
        return false;
    }

    @Override
    public boolean isPushSupported() {
        return true;
    }

    @Override
    public boolean isMultiplexingSupported() {
        return true;
    }

    @Override
    public ClientStatistics getStatistics() {
        return this.clientStatistics;
    }

    @Override
    public boolean isUpgradeSupported() {
        return false;
    }

    @Override
    public void addCloseListener(ChannelListener<ClientConnection> listener) {
        this.closeListeners.add(listener);
    }

    private class Http2ReceiveListener
    implements ChannelListener<Http2Channel> {
        private Http2ReceiveListener() {
        }

        @Override
        public void handleEvent(Http2Channel channel) {
            block23: {
                try {
                    AbstractHttp2StreamSourceChannel result = (AbstractHttp2StreamSourceChannel)channel.receive();
                    if (result instanceof Http2StreamSourceChannel) {
                        final Http2StreamSourceChannel streamSourceChannel = (Http2StreamSourceChannel)result;
                        int statusCode = Integer.parseInt(streamSourceChannel.getHeaders().getFirst(Http2Channel.STATUS));
                        Http2ClientExchange request = (Http2ClientExchange)Http2ClientConnection.this.currentExchanges.get(streamSourceChannel.getStreamId());
                        if (statusCode < 200) {
                            if (statusCode == 100) {
                                request.setContinueResponse(request.createResponse(streamSourceChannel));
                            }
                            Channels.drain(result, Long.MAX_VALUE);
                            return;
                        }
                        result.addCloseTask(new ChannelListener<AbstractHttp2StreamSourceChannel>(){

                            @Override
                            public void handleEvent(AbstractHttp2StreamSourceChannel channel) {
                                Http2ClientConnection.this.currentExchanges.remove(streamSourceChannel.getStreamId());
                            }
                        });
                        streamSourceChannel.setCompletionListener(new ChannelListener<Http2StreamSourceChannel>(){

                            @Override
                            public void handleEvent(Http2StreamSourceChannel channel) {
                                Http2ClientConnection.this.currentExchanges.remove(streamSourceChannel.getStreamId());
                            }
                        });
                        if (request == null && Http2ClientConnection.this.initialUpgradeRequest) {
                            Channels.drain(result, Long.MAX_VALUE);
                            Http2ClientConnection.this.initialUpgradeRequest = false;
                            return;
                        }
                        if (request == null) {
                            channel.sendGoAway(1);
                            IoUtils.safeClose((Closeable)Http2ClientConnection.this);
                            return;
                        }
                        request.responseReady(streamSourceChannel);
                        break block23;
                    }
                    if (result instanceof Http2PingStreamSourceChannel) {
                        this.handlePing((Http2PingStreamSourceChannel)result);
                        break block23;
                    }
                    if (result instanceof Http2RstStreamStreamSourceChannel) {
                        Http2RstStreamStreamSourceChannel rstStream = (Http2RstStreamStreamSourceChannel)result;
                        int stream = rstStream.getStreamId();
                        UndertowLogger.REQUEST_LOGGER.debugf("Client received RST_STREAM for stream %s", stream);
                        Http2ClientExchange exchange = (Http2ClientExchange)Http2ClientConnection.this.currentExchanges.get(stream);
                        if (exchange != null) {
                            exchange.failed(UndertowMessages.MESSAGES.http2StreamWasReset());
                        }
                        Channels.drain(result, Long.MAX_VALUE);
                        break block23;
                    }
                    if (result instanceof Http2PushPromiseStreamSourceChannel) {
                        Http2PushPromiseStreamSourceChannel stream = (Http2PushPromiseStreamSourceChannel)result;
                        Http2ClientExchange request = (Http2ClientExchange)Http2ClientConnection.this.currentExchanges.get(stream.getAssociatedStreamId());
                        if (request == null) {
                            channel.sendGoAway(1);
                        } else if (request.getPushCallback() == null) {
                            channel.sendRstStream(stream.getPushedStreamId(), 7);
                        } else {
                            ClientRequest cr = new ClientRequest();
                            cr.setMethod(new HttpString(stream.getHeaders().getFirst(Http2Channel.METHOD)));
                            cr.setPath(stream.getHeaders().getFirst(Http2Channel.PATH));
                            cr.setProtocol(Protocols.HTTP_1_1);
                            for (HeaderValues header : stream.getHeaders()) {
                                cr.getRequestHeaders().putAll(header.getHeaderName(), header);
                            }
                            Http2ClientExchange newExchange = new Http2ClientExchange(Http2ClientConnection.this, null, cr);
                            if (!request.getPushCallback().handlePush(request, newExchange)) {
                                channel.sendRstStream(stream.getPushedStreamId(), 7);
                                IoUtils.safeClose((Closeable)stream);
                            } else {
                                Http2ClientConnection.this.currentExchanges.put(stream.getPushedStreamId(), newExchange);
                            }
                        }
                        Channels.drain(result, Long.MAX_VALUE);
                        break block23;
                    }
                    if (result instanceof Http2GoAwayStreamSourceChannel) {
                        Http2ClientConnection.this.close();
                        break block23;
                    }
                    if (!channel.isOpen()) {
                        throw UndertowMessages.MESSAGES.channelIsClosed();
                    }
                    if (result == null) break block23;
                    Channels.drain(result, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)Http2ClientConnection.this);
                    for (Map.Entry entry : Http2ClientConnection.this.currentExchanges.entrySet()) {
                        try {
                            ((Http2ClientExchange)entry.getValue()).failed(e);
                        }
                        catch (Exception ex) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
                        }
                    }
                }
            }
        }

        private void handlePing(Http2PingStreamSourceChannel frame) {
            byte[] id = frame.getData();
            if (!frame.isAck()) {
                frame.getHttp2Channel().sendPing(id);
            }
        }
    }
}

