/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.http2.HpackEncoder;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.protocols.http2.Http2Stream;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.HeaderMap;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;

public class Http2DataStreamSinkChannel
extends Http2StreamSinkChannel
implements Http2Stream {
    private final HeaderMap headers;
    private boolean first = true;
    private final HpackEncoder encoder;
    private ChannelListener<Http2DataStreamSinkChannel> completionListener;
    private final int frameType;

    Http2DataStreamSinkChannel(Http2Channel channel, int streamId, int frameType) {
        this(channel, streamId, new HeaderMap(), frameType);
    }

    Http2DataStreamSinkChannel(Http2Channel channel, int streamId, HeaderMap headers, int frameType) {
        super(channel, streamId);
        this.encoder = channel.getEncoder();
        this.headers = headers;
        this.frameType = frameType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int i;
        int dataPaddingBytes = ((Http2Channel)this.getChannel()).getPaddingBytes();
        int attempted = this.getBuffer().remaining() + dataPaddingBytes + (dataPaddingBytes > 0 ? 1 : 0);
        int fcWindow = this.grabFlowControlBytes(attempted);
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        if (fcWindow <= dataPaddingBytes + 1) {
            dataPaddingBytes = this.getBuffer().remaining() >= fcWindow ? 0 : (this.getBuffer().remaining() == dataPaddingBytes ? 1 : fcWindow - this.getBuffer().remaining() - 1);
        }
        boolean finalFrame = this.isWritesShutdown() && fcWindow >= this.getBuffer().remaining();
        PooledByteBuffer firstHeaderBuffer = ((Http2Channel)this.getChannel()).getBufferPool().allocate();
        PooledByteBuffer[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = firstHeaderBuffer.getBuffer();
        boolean firstFrame = false;
        if (this.first) {
            firstFrame = true;
            this.first = false;
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)this.frameType);
            firstBuffer.put((byte)0);
            Http2ProtocolUtils.putInt(firstBuffer, this.getStreamId());
            int paddingBytes = ((Http2Channel)this.getChannel()).getPaddingBytes();
            if (paddingBytes > 0) {
                firstBuffer.put((byte)(paddingBytes & 0xFF));
            }
            this.writeBeforeHeaderBlock(firstBuffer);
            HpackEncoder.State result = this.encoder.encode(this.headers, firstBuffer);
            PooledByteBuffer current = firstHeaderBuffer;
            int headerFrameLength = firstBuffer.position() - 9 + paddingBytes;
            firstBuffer.put(0, (byte)(headerFrameLength >> 16 & 0xFF));
            firstBuffer.put(1, (byte)(headerFrameLength >> 8 & 0xFF));
            firstBuffer.put(2, (byte)(headerFrameLength & 0xFF));
            firstBuffer.put(4, (byte)((this.isWritesShutdown() && !this.getBuffer().hasRemaining() && this.frameType == 1 ? 1 : 0) | (result == HpackEncoder.State.COMPLETE ? 4 : 0) | (paddingBytes > 0 ? 8 : 0)));
            ByteBuffer currentBuffer = firstBuffer;
            if (currentBuffer.remaining() < paddingBytes) {
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, current);
                current = allHeaderBuffers[allHeaderBuffers.length - 1];
                currentBuffer = current.getBuffer();
            }
            for (i = 0; i < paddingBytes; ++i) {
                currentBuffer.put((byte)0);
            }
            while (result != HpackEncoder.State.COMPLETE) {
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, current);
                current = allHeaderBuffers[allHeaderBuffers.length - 1];
                currentBuffer = current.getBuffer();
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)9);
                currentBuffer.put((byte)0);
                Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
                result = this.encoder.encode(this.headers, currentBuffer);
                int contFrameLength = currentBuffer.position() - 9;
                currentBuffer.put(0, (byte)(contFrameLength >> 16 & 0xFF));
                currentBuffer.put(1, (byte)(contFrameLength >> 8 & 0xFF));
                currentBuffer.put(2, (byte)(contFrameLength & 0xFF));
                currentBuffer.put(4, (byte)(result == HpackEncoder.State.COMPLETE ? 4 : 0));
            }
        }
        PooledByteBuffer currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = currentPooled.getBuffer();
        ByteBuffer trailer = null;
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            if (fcWindow > 0) {
                if (currentBuffer.remaining() < 10) {
                    currentPooled = (allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled)) == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
                    currentBuffer = currentPooled.getBuffer();
                }
                int toSend = fcWindow - dataPaddingBytes - (dataPaddingBytes > 0 ? 1 : 0);
                remainingInBuffer = this.getBuffer().remaining() - toSend;
                this.getBuffer().limit(this.getBuffer().position() + toSend);
                currentBuffer.put((byte)(fcWindow >> 16 & 0xFF));
                currentBuffer.put((byte)(fcWindow >> 8 & 0xFF));
                currentBuffer.put((byte)(fcWindow & 0xFF));
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)((finalFrame ? 1 : 0) | (dataPaddingBytes > 0 ? 8 : 0)));
                Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
                if (dataPaddingBytes > 0) {
                    currentBuffer.put((byte)(dataPaddingBytes & 0xFF));
                    trailer = ByteBuffer.allocate(dataPaddingBytes);
                }
            } else {
                remainingInBuffer = this.getBuffer().remaining();
            }
        } else if (finalFrame && !firstFrame) {
            currentBuffer.put((byte)(fcWindow >> 16 & 0xFF));
            currentBuffer.put((byte)(fcWindow >> 8 & 0xFF));
            currentBuffer.put((byte)(fcWindow & 0xFF));
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)(1 | (dataPaddingBytes > 0 ? 8 : 0)));
            Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
            if (dataPaddingBytes > 0) {
                currentBuffer.put((byte)(dataPaddingBytes & 0xFF));
                trailer = ByteBuffer.allocate(dataPaddingBytes);
            }
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled, false, trailer);
        }
        int length = 0;
        for (i = 0; i < allHeaderBuffers.length; ++i) {
            length += allHeaderBuffers[i].getBuffer().position();
            allHeaderBuffers[i].getBuffer().flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i2 = 0; i2 < allHeaderBuffers.length; ++i2) {
                newBuf.put(allHeaderBuffers[i2].getBuffer());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooledByteBuffer(newBuf), false, trailer);
            return sendFrameHeader;
        }
        finally {
            for (int i3 = 0; i3 < allHeaderBuffers.length; ++i3) {
                allHeaderBuffers[i3].close();
            }
        }
    }

    protected void writeBeforeHeaderBlock(ByteBuffer buffer) {
    }

    @Override
    protected boolean isFlushRequiredOnEmptyBuffer() {
        return this.first;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        super.handleFlushComplete(finalFrame);
        if (finalFrame && this.completionListener != null) {
            ChannelListeners.invokeChannelListener(this, this.completionListener);
        }
    }

    public ChannelListener<Http2DataStreamSinkChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<Http2DataStreamSinkChannel> completionListener) {
        this.completionListener = completionListener;
    }
}

