/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;

public class ServletChain {
    private final HttpHandler handler;
    private final ManagedServlet managedServlet;
    private final String servletPath;
    private final Executor executor;
    private final boolean defaultServletMapping;
    private final Map<DispatcherType, List<ManagedFilter>> filters;

    public ServletChain(HttpHandler handler, ManagedServlet managedServlet, String servletPath, boolean defaultServletMapping, Map<DispatcherType, List<ManagedFilter>> filters) {
        this(handler, managedServlet, servletPath, defaultServletMapping, filters, true);
    }

    private ServletChain(final HttpHandler originalHandler, ManagedServlet managedServlet, String servletPath, boolean defaultServletMapping, Map<DispatcherType, List<ManagedFilter>> filters, boolean wrapHandler) {
        this.handler = wrapHandler ? new HttpHandler(){
            private volatile boolean initDone = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!this.initDone) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.initDone) {
                            ServletRequestContext src = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                            ServletChain.this.forceInit(src.getDispatcherType());
                        }
                    }
                }
                originalHandler.handleRequest(exchange);
            }
        } : originalHandler;
        this.managedServlet = managedServlet;
        this.servletPath = servletPath;
        this.defaultServletMapping = defaultServletMapping;
        this.executor = managedServlet.getServletInfo().getExecutor();
        this.filters = filters;
    }

    public ServletChain(ServletChain other) {
        this(other.getHandler(), other.getManagedServlet(), other.getServletPath(), other.isDefaultServletMapping(), other.filters, false);
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isDefaultServletMapping() {
        return this.defaultServletMapping;
    }

    void forceInit(DispatcherType dispatcherType) throws ServletException {
        List<ManagedFilter> list;
        if (this.filters != null && (list = this.filters.get((Object)dispatcherType)) != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ManagedFilter filter = list.get(i);
                filter.forceInit();
            }
        }
        this.managedServlet.forceInit();
    }
}

