/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2DataStreamSinkChannel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.protocol.http2.Http2SslSessionInfo;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.channels.Channels;

public class Http2ReceiveListener
implements ChannelListener<Http2Channel> {
    static final HttpString METHOD = new HttpString(":method");
    static final HttpString PATH = new HttpString(":path");
    static final HttpString SCHEME = new HttpString(":scheme");
    static final HttpString AUTHORITY = new HttpString(":authority");
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean allowEncodingSlash;
    private final int bufferSize;
    private final int maxParameters;
    private final ConnectorStatisticsImpl connectorStatistics;
    private static final AtomicIntegerFieldUpdater<Http2ReceiveListener> concurrentRequestsUpdater = AtomicIntegerFieldUpdater.newUpdater(Http2ReceiveListener.class, "concurrentRequests");
    private volatile int concurrentRequests;

    public Http2ReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize, ConnectorStatisticsImpl connectorStatistics) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.connectorStatistics = connectorStatistics;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.allowEncodingSlash = undertowOptions.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.maxParameters = undertowOptions.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name()) : null;
    }

    @Override
    public void handleEvent(Http2Channel channel) {
        try {
            AbstractHttp2StreamSourceChannel frame = (AbstractHttp2StreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof Http2StreamSourceChannel) {
                this.handleRequests(channel, (Http2StreamSourceChannel)frame);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handleRequests(Http2Channel channel, Http2StreamSourceChannel frame) {
        Http2StreamSourceChannel dataChannel = frame;
        Http2ServerConnection connection = new Http2ServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize, this.rootHandler);
        if (!this.checkRequestHeaders(dataChannel.getHeaders())) {
            channel.sendRstStream(frame.getStreamId(), 1);
            try {
                Channels.drain(frame, Long.MAX_VALUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        final HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
        connection.setExchange(exchange);
        dataChannel.setMaxStreamSize(this.maxEntitySize);
        exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(SCHEME));
        exchange.setProtocol(Protocols.HTTP_2_0);
        exchange.setRequestMethod(Methods.fromString(exchange.getRequestHeaders().getFirst(METHOD)));
        exchange.getRequestHeaders().put(Headers.HOST, exchange.getRequestHeaders().getFirst(AUTHORITY));
        String path = exchange.getRequestHeaders().getFirst(PATH);
        Connectors.setExchangeRequestPath(exchange, path, this.encoding, this.decode, this.allowEncodingSlash, this.decodeBuffer, this.maxParameters);
        SSLSession session = channel.getSslSession();
        if (session != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        dataChannel.getResponseChannel().setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange);
            }
        });
        if (!dataChannel.isOpen()) {
            Connectors.terminateRequest(exchange);
        } else {
            dataChannel.setCompletionListener(new ChannelListener<Http2StreamSourceChannel>(){

                @Override
                public void handleEvent(Http2StreamSourceChannel channel) {
                    Connectors.terminateRequest(exchange);
                }
            });
        }
        if (this.connectorStatistics != null) {
            this.connectorStatistics.setup(exchange);
        }
        exchange.getRequestHeaders().remove(AUTHORITY);
        exchange.getRequestHeaders().remove(PATH);
        exchange.getRequestHeaders().remove(SCHEME);
        exchange.getRequestHeaders().remove(METHOD);
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    void handleInitialRequest(HttpServerExchange initial, Http2Channel channel) {
        Http2HeadersStreamSinkChannel sink = channel.createInitialUpgradeResponseStream();
        Http2ServerConnection connection = new Http2ServerConnection(channel, sink, this.undertowOptions, this.bufferSize, this.rootHandler);
        HeaderMap requestHeaders = new HeaderMap();
        for (HeaderValues hv : initial.getRequestHeaders()) {
            requestHeaders.putAll(hv.getHeaderName(), hv);
        }
        final HttpServerExchange exchange = new HttpServerExchange(connection, requestHeaders, sink.getHeaders(), this.maxEntitySize);
        connection.setExchange(exchange);
        exchange.setRequestScheme(initial.getRequestScheme());
        exchange.setProtocol(initial.getProtocol());
        exchange.setRequestMethod(initial.getRequestMethod());
        exchange.setQueryString(initial.getQueryString());
        String uri = exchange.getQueryString().isEmpty() ? initial.getRequestURI() : initial.getRequestURI() + '?' + exchange.getQueryString();
        Connectors.setExchangeRequestPath(exchange, uri, this.encoding, this.decode, this.allowEncodingSlash, this.decodeBuffer, this.maxParameters);
        SSLSession session = channel.getSslSession();
        if (session != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        Connectors.terminateRequest(exchange);
        sink.setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange);
            }
        });
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    private boolean checkRequestHeaders(HeaderMap headers) {
        if (headers.count(METHOD) != 1 || headers.contains(Headers.CONNECTION)) {
            return false;
        }
        if (headers.get(METHOD).contains(Methods.CONNECT) ? headers.contains(SCHEME) || headers.contains(PATH) || headers.count(AUTHORITY) != 1 : headers.count(SCHEME) != 1 || headers.count(PATH) != 1) {
            return false;
        }
        if (headers.contains(Headers.TE)) {
            for (String value : headers.get(Headers.TE)) {
                if (value.equals("trailers")) continue;
                return false;
            }
        }
        return true;
    }
}

