/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;

public class SSLInformationAssociationHandler
implements HttpHandler {
    private final HttpHandler next;

    public SSLInformationAssociationHandler(HttpHandler next) {
        this.next = next;
    }

    public static int getKeyLength(String cipherSuite) {
        return SSLSessionInfo.calculateKeySize(cipherSuite);
    }

    private X509Certificate[] getCerts(SSLSessionInfo session) {
        try {
            javax.security.cert.X509Certificate[] javaxCerts = session.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            X509Certificate[] javaCerts = new X509Certificate[javaxCerts.length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < javaxCerts.length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequest request = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getServletRequest();
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl != null) {
            String cipherSuite = ssl.getCipherSuite();
            byte[] sessionId = ssl.getSessionId();
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", ssl.getKeySize());
            request.setAttribute("javax.servlet.request.ssl_session_id", sessionId != null ? HexConverter.convertToHexString(sessionId) : null);
            X509Certificate[] certs = this.getCerts(ssl);
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
        }
        this.next.handleRequest(exchange);
    }
}

