/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.servlet;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.examples.servlet.MessageServlet;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import javax.servlet.ServletException;

@UndertowExample(value="Servlet")
public class ServletServer {
    public static final String MYAPP = "/myapp";

    public static void main(String[] args) {
        try {
            DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(ServletServer.class.getClassLoader()).setContextPath(MYAPP).setDeploymentName("test.war").addServlets(Servlets.servlet("MessageServlet", MessageServlet.class).addInitParam("message", "Hello World").addMapping("/*"), Servlets.servlet("MyServlet", MessageServlet.class).addInitParam("message", "MyServlet").addMapping("/myservlet"));
            DeploymentManager manager = Servlets.defaultContainer().addDeployment(servletBuilder);
            manager.deploy();
            HttpHandler servletHandler = manager.start();
            PathHandler path = Handlers.path(Handlers.redirect(MYAPP)).addPrefixPath(MYAPP, servletHandler);
            Undertow server = Undertow.builder().addHttpListener(8080, "localhost").setHandler(path).build();
            server.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }
}

