/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.UndertowLogger;
import io.undertow.predicate.Predicate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PredicatesHandler
implements HttpHandler {
    public static final AttachmentKey<Boolean> DONE = AttachmentKey.create(Boolean.class);
    public static final AttachmentKey<Boolean> RESTART = AttachmentKey.create(Boolean.class);
    private static final boolean traceEnabled = UndertowLogger.PREDICATE_LOGGER.isTraceEnabled();
    private volatile Holder[] handlers = new Holder[0];
    private volatile HttpHandler next;
    private final boolean outerHandler;
    private final AttachmentKey<Integer> CURRENT_POSITION = AttachmentKey.create(Integer.class);

    public PredicatesHandler(HttpHandler next) {
        this.next = next;
        this.outerHandler = true;
    }

    public PredicatesHandler(HttpHandler next, boolean outerHandler) {
        this.next = next;
        this.outerHandler = outerHandler;
    }

    public String toString() {
        return "PredicatesHandler with " + this.handlers.length + " predicates";
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        int length = this.handlers.length;
        Integer current = exchange.getAttachment(this.CURRENT_POSITION);
        block0: do {
            int pos;
            if (current == null) {
                if (this.outerHandler) {
                    exchange.removeAttachment(RESTART);
                    exchange.removeAttachment(DONE);
                    if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
                        exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
                    }
                }
                pos = 0;
            } else {
                if (exchange.getAttachment(DONE) != null) {
                    if (traceEnabled && this.outerHandler) {
                        UndertowLogger.PREDICATE_LOGGER.tracef("Predicate chain marked done. Next handler is [%s] for %s.", (Object)this.next.toString(), (Object)exchange);
                    }
                    exchange.removeAttachment(this.CURRENT_POSITION);
                    this.next.handleRequest(exchange);
                    return;
                }
                pos = current;
            }
            while (pos < length) {
                Holder handler = this.handlers[pos];
                if (handler.predicate.resolve(exchange)) {
                    if (traceEnabled) {
                        if (handler.predicate.toString().equals("true")) {
                            UndertowLogger.PREDICATE_LOGGER.tracef("Executing handler [%s] for %s.", (Object)handler.handler.toString(), (Object)exchange);
                        } else {
                            UndertowLogger.PREDICATE_LOGGER.tracef("Predicate [%s] resolved to true. Next handler is [%s] for %s.", (Object)handler.predicate.toString(), (Object)handler.handler.toString(), (Object)exchange);
                        }
                    }
                    exchange.putAttachment(this.CURRENT_POSITION, pos + 1);
                    handler.handler.handleRequest(exchange);
                    if (this.shouldRestart(exchange, current)) {
                        if (!traceEnabled) continue block0;
                        UndertowLogger.PREDICATE_LOGGER.tracef("Restarting predicate resolution for %s.", (Object)exchange);
                        continue block0;
                    }
                    return;
                }
                if (handler.elseBranch != null) {
                    if (traceEnabled) {
                        UndertowLogger.PREDICATE_LOGGER.tracef("Predicate [%s] resolved to false. Else branch is [%s] for %s.", (Object)handler.predicate.toString(), (Object)handler.elseBranch.toString(), (Object)exchange);
                    }
                    exchange.putAttachment(this.CURRENT_POSITION, pos + 1);
                    handler.elseBranch.handleRequest(exchange);
                    if (this.shouldRestart(exchange, current)) {
                        if (!traceEnabled) continue block0;
                        UndertowLogger.PREDICATE_LOGGER.tracef("Restarting predicate resolution for %s.", (Object)exchange);
                        continue block0;
                    }
                    return;
                }
                if (traceEnabled) {
                    UndertowLogger.PREDICATE_LOGGER.tracef("Predicate [%s] resolved to false for %s.", (Object)handler.predicate.toString(), (Object)exchange);
                }
                ++pos;
            }
        } while (this.shouldRestart(exchange, current));
        this.next.handleRequest(exchange);
    }

    private boolean shouldRestart(HttpServerExchange exchange, Integer current) {
        return exchange.getAttachment(RESTART) != null && this.outerHandler && current == null;
    }

    public PredicatesHandler addPredicatedHandler(Predicate predicate, HandlerWrapper handlerWrapper, HandlerWrapper elseBranch) {
        Holder[] old = this.handlers;
        Holder[] handlers = new Holder[old.length + 1];
        System.arraycopy(old, 0, handlers, 0, old.length);
        HttpHandler elseHandler = elseBranch != null ? elseBranch.wrap(this) : null;
        handlers[old.length] = new Holder(predicate, handlerWrapper.wrap(this), elseHandler);
        this.handlers = handlers;
        return this;
    }

    public PredicatesHandler addPredicatedHandler(Predicate predicate, HandlerWrapper handlerWrapper) {
        this.addPredicatedHandler(predicate, handlerWrapper, null);
        return this;
    }

    public PredicatesHandler addPredicatedHandler(PredicatedHandler handler) {
        return this.addPredicatedHandler(handler.getPredicate(), handler.getHandler(), handler.getElseHandler());
    }

    public void setNext(HttpHandler next) {
        this.next = next;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public static class Wrapper
    implements HandlerWrapper {
        private final List<PredicatedHandler> handlers;
        private final boolean outerHandler;

        public Wrapper(List<PredicatedHandler> handlers, boolean outerHandler) {
            this.handlers = handlers;
            this.outerHandler = outerHandler;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            PredicatesHandler h = new PredicatesHandler(handler, this.outerHandler);
            for (PredicatedHandler pred : this.handlers) {
                h.addPredicatedHandler(pred.getPredicate(), pred.getHandler());
            }
            return h;
        }
    }

    public static final class RestartHandlerBuilder
    implements HandlerBuilder {
        private static final AttachmentKey<Integer> RESTART_COUNT = AttachmentKey.create(Integer.class);
        private static final int MAX_RESTARTS = Integer.getInteger("io.undertow.max_restarts", 1000);

        @Override
        public String name() {
            return "restart";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new HttpHandler(){

                        @Override
                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            Integer restarts = (Integer)exchange.getAttachment(RESTART_COUNT);
                            if (restarts == null) {
                                restarts = 1;
                            } else {
                                Integer n = restarts;
                                Integer n2 = restarts = Integer.valueOf(restarts + 1);
                            }
                            exchange.putAttachment(RESTART_COUNT, restarts);
                            if (restarts > MAX_RESTARTS) {
                                throw UndertowLogger.ROOT_LOGGER.maxRestartsExceeded(MAX_RESTARTS);
                            }
                            exchange.putAttachment(RESTART, true);
                        }

                        public String toString() {
                            return "restart";
                        }
                    };
                }
            };
        }
    }

    public static final class DoneHandlerBuilder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "done";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(final HttpHandler handler) {
                    return new HttpHandler(){

                        @Override
                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            exchange.putAttachment(DONE, true);
                            handler.handleRequest(exchange);
                        }

                        public String toString() {
                            return "done";
                        }
                    };
                }
            };
        }
    }

    private static final class Holder {
        final Predicate predicate;
        final HttpHandler handler;
        final HttpHandler elseBranch;

        private Holder(Predicate predicate, HttpHandler handler, HttpHandler elseBranch) {
            this.predicate = predicate;
            this.handler = handler;
            this.elseBranch = elseBranch;
        }
    }
}

