/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.annotationprocessor;

import io.undertow.annotationprocessor.AbstractParserGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;

public class RequestParserGenerator
extends AbstractParserGenerator {
    public static final String PARSE_STATE_CLASS = "io.undertow.server.ParseState";
    public static final String HTTP_EXCHANGE_CLASS = "io.undertow.server.HttpServerExchange";
    public static final int VERB = 0;
    public static final int PATH = 1;
    public static final int VERSION = 2;
    public static final int AFTER_VERSION = 3;
    public static final int HEADER = 4;
    public static final int HEADER_VALUE = 5;

    public RequestParserGenerator() {
        super(PARSE_STATE_CLASS, HTTP_EXCHANGE_CLASS);
    }

    @Override
    protected void createStateMachines(String[] httpVerbs, String[] httpVersions, String[] standardHeaders, String className, ClassFile file, ClassMethod sctor, AtomicInteger fieldCounter) {
        this.createStateMachine(httpVerbs, className, file, sctor, fieldCounter, "handleHttpVerb", new VerbStateMachine());
        this.createStateMachine(httpVersions, className, file, sctor, fieldCounter, "handleHttpVersion", new VersionStateMachine());
        this.createStateMachine(standardHeaders, className, file, sctor, fieldCounter, "handleHeader", new HeaderStateMachine());
    }

    private class VerbStateMachine
    implements AbstractParserGenerator.CustomStateMachine {
        private VerbStateMachine() {
        }

        @Override
        public boolean isHeader() {
            return false;
        }

        @Override
        public void handleStateMachineMatchedToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(RequestParserGenerator.this.resultClass, "setRequestMethod", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void handleOtherToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(RequestParserGenerator.this.resultClass, "setRequestMethod", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void updateParseState(CodeAttribute c) {
            c.pop();
            c.aload(2);
            c.iconst(1);
            c.putfield(RequestParserGenerator.this.parseStateClass, "state", "I");
        }

        @Override
        public boolean initialNewlineMeansRequestDone() {
            return false;
        }
    }

    protected class VersionStateMachine
    implements AbstractParserGenerator.CustomStateMachine {
        protected VersionStateMachine() {
        }

        @Override
        public boolean isHeader() {
            return false;
        }

        @Override
        public void handleOtherToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(RequestParserGenerator.this.resultClass, "setProtocol", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void handleStateMachineMatchedToken(CodeAttribute c) {
            c.aload(3);
            c.swap();
            c.invokevirtual(RequestParserGenerator.this.resultClass, "setProtocol", "(" + AbstractParserGenerator.HTTP_STRING_DESCRIPTOR + ")V");
        }

        @Override
        public void updateParseState(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(RequestParserGenerator.this.parseStateClass, "leftOver", "B");
            c.aload(2);
            c.iconst(3);
            c.putfield(RequestParserGenerator.this.parseStateClass, "state", "I");
        }

        @Override
        public boolean initialNewlineMeansRequestDone() {
            return false;
        }
    }

    protected class HeaderStateMachine
    implements AbstractParserGenerator.CustomStateMachine {
        protected HeaderStateMachine() {
        }

        @Override
        public boolean isHeader() {
            return true;
        }

        @Override
        public void handleOtherToken(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(RequestParserGenerator.this.parseStateClass, "nextHeader", AbstractParserGenerator.HTTP_STRING_DESCRIPTOR);
        }

        @Override
        public void handleStateMachineMatchedToken(CodeAttribute c) {
            c.aload(2);
            c.swap();
            c.putfield(RequestParserGenerator.this.parseStateClass, "nextHeader", AbstractParserGenerator.HTTP_STRING_DESCRIPTOR);
        }

        @Override
        public void updateParseState(CodeAttribute c) {
            c.pop();
            c.aload(2);
            c.iconst(5);
            c.putfield(RequestParserGenerator.this.parseStateClass, "state", "I");
        }

        @Override
        public boolean initialNewlineMeansRequestDone() {
            return true;
        }
    }
}

