/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.IoUtils;

public class DefaultServlet
extends HttpServlet {
    private final Deployment deployment;
    private final DefaultServletConfig config;
    private final List<String> welcomePages;

    public DefaultServlet(Deployment deployment, DefaultServletConfig config, List<String> welcomePages) {
        this.deployment = deployment;
        this.config = config;
        this.welcomePages = welcomePages;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getPath(req);
        if (!this.isAllowed(path)) {
            resp.sendError(404);
            return;
        }
        File resource = this.deployment.getDeploymentInfo().getResourceLoader().getResource(path);
        if (resource == null) {
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                throw new FileNotFoundException(path);
            }
            resp.sendError(404);
            return;
        }
        if (resource.isDirectory()) {
            this.handleWelcomePage(req, resp, resource);
        } else {
            this.serveFileBlocking(resp, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFileBlocking(HttpServletResponse resp, File resource) throws IOException {
        ServletOutputStream out = null;
        PrintWriter writer = null;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(resource));
        try {
            out = resp.getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = resp.getWriter();
        }
        try {
            if (out != null) {
                int read;
                byte[] buffer = new byte[1024];
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            } else {
                int read;
                InputStreamReader reader = new InputStreamReader(in);
                char[] buffer = new char[1024];
                while ((read = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, read);
                }
            }
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
    }

    private void handleWelcomePage(HttpServletRequest req, HttpServletResponse resp, File resource) throws IOException, ServletException {
        File welcomePage = this.findWelcomeFile(resource);
        if (welcomePage != null) {
            this.serveFileBlocking(resp, welcomePage);
        } else {
            ServletPathMatch handler;
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "";
            }
            if ((handler = this.findWelcomeServlet(pathInfo.endsWith("/") ? pathInfo : pathInfo + "/")) != null) {
                HttpServletRequestImpl servletRequestImpl = HttpServletRequestImpl.getRequestImpl((ServletRequest)req);
                HttpServerExchange exchange = servletRequestImpl.getExchange();
                exchange.setRequestPath(exchange.getResolvedPath() + handler.getMatched());
                exchange.setRequestURI(exchange.getResolvedPath() + handler.getMatched());
                exchange.putAttachment(ServletAttachments.SERVLET_PATH_MATCH, (Object)handler);
                try {
                    handler.getHandler().handleBlockingRequest(exchange);
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            } else {
                resp.sendError(404);
            }
        }
    }

    private File findWelcomeFile(File resource) {
        for (String i : this.welcomePages) {
            File res = new File(resource + File.separator + i);
            if (!res.exists()) continue;
            return res;
        }
        return null;
    }

    private ServletPathMatch findWelcomeServlet(String path) {
        for (String i : this.welcomePages) {
            ServletPathMatch handler = this.deployment.getServletPaths().getServletHandlerByExactPath(path + i);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private String getPath(HttpServletRequest request) {
        if (request.getDispatcherType() == DispatcherType.INCLUDE && request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    private boolean isAllowed(String path) {
        if (!path.isEmpty() && (path.startsWith("/META-INF") || path.startsWith("META-INF") || path.startsWith("/WEB-INF") || path.startsWith("WEB-INF"))) {
            return false;
        }
        int pos = path.lastIndexOf(47);
        String lastSegment = pos == -1 ? path : path.substring(pos + 1);
        if (lastSegment.isEmpty()) {
            return true;
        }
        int ext = lastSegment.lastIndexOf(46);
        if (ext == -1) {
            return true;
        }
        String extension = lastSegment.substring(ext + 1, lastSegment.length());
        if (this.config.isDefaultAllowed()) {
            return !this.config.getDisallowed().contains(extension);
        }
        return this.config.getAllowed().contains(extension);
    }
}

