/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;

public class RequestListenerHandler
implements BlockingHttpHandler {
    private final ApplicationListeners listeners;
    private final BlockingHttpHandler next;

    public RequestListenerHandler(ApplicationListeners listeners, BlockingHttpHandler next) {
        this.listeners = listeners;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBlockingRequest(HttpServerExchange exchange) throws Exception {
        DispatcherType type = (DispatcherType)exchange.getAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY);
        if (type == DispatcherType.REQUEST) {
            ServletRequest request = (ServletRequest)exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
            this.listeners.requestInitialized(request);
            try {
                this.next.handleBlockingRequest(exchange);
            }
            finally {
                if (!request.isAsyncStarted()) {
                    this.listeners.requestDestroyed(request);
                }
            }
        } else if (type == DispatcherType.ASYNC) {
            ServletRequest request = (ServletRequest)exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
            try {
                this.next.handleBlockingRequest(exchange);
            }
            finally {
                if (!request.isAsyncStarted()) {
                    this.listeners.requestDestroyed(request);
                }
            }
        } else {
            this.next.handleBlockingRequest(exchange);
        }
    }

    public BlockingHttpHandler getNext() {
        return this.next;
    }
}

