/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;

public class ServletMatchingHandler
implements HttpHandler {
    private volatile ServletPathMatches paths;
    private final HttpHandler next;

    public ServletMatchingHandler(ServletPathMatches paths, HttpHandler next) {
        this.paths = paths;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) {
        String path = exchange.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        exchange.putAttachment(ServletAttachments.SERVLET_PATH_MATCH, (Object)info);
        exchange.putAttachment(ServletAttachments.CURRENT_SERVLET, (Object)info.getHandler().getManagedServlet().getServletInfo());
        HttpHandlers.executeHandler((HttpHandler)this.next, (HttpServerExchange)exchange);
    }

    public ServletPathMatches getPaths() {
        return this.paths;
    }

    public ServletMatchingHandler setPaths(ServletPathMatches paths) {
        this.paths = paths;
        return this;
    }
}

