/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import java.util.ArrayList;
import java.util.Set;

public class ServletSecurityConstraintHandler
implements HttpHandler {
    private final SecurityPathMatches securityPathMatches;
    private final HttpHandler next;

    public ServletSecurityConstraintHandler(SecurityPathMatches securityPathMatches, HttpHandler next) {
        this.securityPathMatches = securityPathMatches;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) {
        String path = exchange.getRelativePath();
        SecurityPathMatch securityMatch = this.securityPathMatches.getSecurityInfo(path, exchange.getRequestMethod().toString());
        ArrayList<Set<String>> list = (ArrayList<Set<String>>)exchange.getAttachment(ServletAttachments.REQUIRED_ROLES);
        if (list == null) {
            list = new ArrayList<Set<String>>();
            exchange.putAttachment(ServletAttachments.REQUIRED_ROLES, list);
        }
        list.addAll(securityMatch.getRequiredRoles());
        TransportGuaranteeType type = (TransportGuaranteeType)((Object)exchange.getAttachment(ServletAttachments.TRANSPORT_GUARANTEE_TYPE));
        if (type == null || type.ordinal() < securityMatch.getTransportGuaranteeType().ordinal()) {
            exchange.putAttachment(ServletAttachments.TRANSPORT_GUARANTEE_TYPE, (Object)securityMatch.getTransportGuaranteeType());
        }
        HttpHandlers.executeHandler((HttpHandler)this.next, (HttpServerExchange)exchange);
    }
}

