/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.util.IteratorEnumeration;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private final Session session;
    private final ServletContext servletContext;
    private final ApplicationListeners applicationListeners;
    private final HttpServerExchange exchange;
    private final boolean newSession;
    private volatile boolean invalid;

    public HttpSessionImpl(Session session, ServletContext servletContext, ApplicationListeners applicationListeners, HttpServerExchange exchange, boolean newSession) {
        this.session = session;
        this.servletContext = servletContext;
        this.applicationListeners = applicationListeners;
        this.exchange = exchange;
        this.newSession = newSession;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.session.getAttributeNames().iterator());
    }

    public String[] getValueNames() {
        Set names = this.session.getAttributeNames();
        String[] ret = new String[names.size()];
        int i = 0;
        for (String name : names) {
            ret[i++] = name;
        }
        return ret;
    }

    public void setAttribute(String name, Object value) {
        Object old = this.session.setAttribute(name, value);
        if (value == null && old != null) {
            this.applicationListeners.httpSessionAttributeRemoved(this, name, old);
        } else if (old == null) {
            this.applicationListeners.httpSessionAttributeAdded(this, name, value);
        } else {
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, old));
            }
            this.applicationListeners.httpSessionAttributeReplaced(this, name, old);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        Object old = this.session.removeAttribute(name);
        this.applicationListeners.httpSessionAttributeRemoved(this, name, old);
        if (old instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, old));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.invalid = true;
        this.applicationListeners.sessionDestroyed(this);
        this.session.invalidate(this.exchange);
    }

    public boolean isNew() {
        if (this.invalid) {
            throw UndertowServletMessages.MESSAGES.sessionIsInvalid();
        }
        return this.newSession;
    }

    public Session getSession() {
        return this.session;
    }
}

