/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class ServletInputStreamImpl
extends ServletInputStream {
    private final HttpServletRequestImpl request;
    private final StreamSourceChannel channel;
    private volatile ReadListener listener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private int state;
    private AsyncContextImpl asyncContext;

    public ServletInputStreamImpl(HttpServletRequestImpl request) {
        this.request = request;
        this.channel = request.getExchange().getRequestChannel();
    }

    public boolean isFinished() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public boolean isReady() {
        return Bits.anyAreSet((int)this.state, (int)1) && !this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("readListener");
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        if (!this.request.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = this.request.getAsyncContext();
        this.listener = readListener;
        this.channel.getReadSetter().set((ChannelListener)new UpgradeServletChannelListener());
        this.channel.resumeReads();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b);
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        if (this.listener == null) {
            int res = Channels.readBlocking((ReadableByteChannel)this.channel, (ByteBuffer)buffer);
            if (res == -1) {
                this.state |= 4;
            }
            return res;
        }
        if (Bits.anyAreClear((int)this.state, (int)1)) {
            throw UndertowServletMessages.MESSAGES.streamNotReady();
        }
        int res = this.channel.read(buffer);
        if (res == -1) {
            this.state |= 4;
        } else if (res == 0) {
            this.state &= 0xFFFFFFFE;
            this.channel.resumeReads();
        }
        return res;
    }

    public void close() throws IOException {
        this.channel.shutdownReads();
        this.state |= 6;
    }

    private class UpgradeServletChannelListener
    implements ChannelListener<StreamSourceChannel> {
        private UpgradeServletChannelListener() {
        }

        public void handleEvent(final StreamSourceChannel channel) {
            if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) {
                return;
            }
            ServletInputStreamImpl.this.state |= 1;
            channel.suspendReads();
            ServletInputStreamImpl.this.asyncContext.addAsyncTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ThreadSetupAction.Handle handle;
                    CompositeThreadSetupAction action;
                    try {
                        action = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                        handle = action.setup(ServletInputStreamImpl.this.request.getExchange());
                        try {
                            ServletInputStreamImpl.this.listener.onDataAvailable();
                        }
                        finally {
                            handle.tearDown();
                        }
                    }
                    catch (Exception e) {
                        CompositeThreadSetupAction action2 = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                        ThreadSetupAction.Handle handle2 = action2.setup(ServletInputStreamImpl.this.request.getExchange());
                        try {
                            ServletInputStreamImpl.this.listener.onError((Throwable)e);
                        }
                        finally {
                            handle2.tearDown();
                        }
                        IoUtils.safeClose((Closeable)channel);
                    }
                    if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) {
                        if (Bits.anyAreClear((int)ServletInputStreamImpl.this.state, (int)8)) {
                            try {
                                ServletInputStreamImpl.this.state |= 8;
                                channel.shutdownReads();
                                action = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                                handle = action.setup(ServletInputStreamImpl.this.request.getExchange());
                                try {
                                    ServletInputStreamImpl.this.listener.onAllDataRead();
                                }
                                finally {
                                    handle.tearDown();
                                }
                            }
                            catch (IOException e) {
                                ServletInputStreamImpl.this.listener.onError((Throwable)e);
                                IoUtils.safeClose((Closeable)channel);
                            }
                        }
                    } else if (!ServletInputStreamImpl.this.isReady()) {
                        channel.resumeReads();
                    }
                }
            });
        }
    }
}

