/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.WriteListener;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class ServletOutputStreamImpl
extends ServletOutputStream {
    private final HttpServletResponseImpl servletResponse;
    private Pooled<ByteBuffer> pooledBuffer;
    private ByteBuffer buffer;
    private Integer bufferSize;
    private StreamSinkChannel channel;
    private long written;
    private int state;
    private final Long contentLength;
    private AsyncContextImpl asyncContext;
    private WriteListener listener;
    private WriteChannelListener internalListener;
    private ByteBuffer[] buffersToWrite;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int FLAG_READY = 4;
    private static final int FLAG_DELEGATE_SHUTDOWN = 8;
    private static final int FLAG_IN_CALLBACK = 16;
    private final ConnectedStreamChannel underlyingConnectionChannel;
    private CompositeThreadSetupAction threadSetupAction;

    public ServletOutputStreamImpl(Long contentLength, HttpServletResponseImpl servletResponse) {
        this.servletResponse = servletResponse;
        this.contentLength = contentLength;
        this.underlyingConnectionChannel = servletResponse.getExchange().getConnection().getChannel();
        this.threadSetupAction = servletResponse.getServletContext().getDeployment().getThreadSetupAction();
    }

    public ServletOutputStreamImpl(Long contentLength, HttpServletResponseImpl servletResponse, int bufferSize) {
        this.servletResponse = servletResponse;
        this.bufferSize = bufferSize;
        this.contentLength = contentLength;
        this.underlyingConnectionChannel = servletResponse.getExchange().getConnection().getChannel();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener == null) {
            int remaining;
            if (len < 1) {
                return;
            }
            ByteBuffer buffer = this.buffer();
            for (int written = 0; written < len; written += remaining) {
                if (buffer.remaining() >= len - written) {
                    buffer.put(b, off + written, len - written);
                    if (buffer.remaining() == 0) {
                        this.writeBufferBlocking();
                    }
                    this.updateWritten(len);
                    return;
                }
                remaining = buffer.remaining();
                buffer.put(b, off + written, remaining);
                this.writeBufferBlocking();
            }
            this.updateWritten(len);
        } else {
            if (Bits.anyAreClear((int)this.state, (int)4)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            if (len < 1) {
                return;
            }
            try {
                ByteBuffer buffer = this.buffer();
                if (buffer.remaining() > len) {
                    buffer.put(b, off, len);
                } else {
                    buffer.flip();
                    ByteBuffer userBuffer = ByteBuffer.wrap(b, off, len);
                    Buffer[] bufs = new ByteBuffer[]{buffer, userBuffer};
                    long toWrite = Buffers.remaining((Buffer[])bufs);
                    long written = 0L;
                    if (this.channel == null) {
                        this.channel = this.servletResponse.getExchange().getResponseChannel();
                    }
                    this.state |= 2;
                    do {
                        long res = this.channel.write((ByteBuffer[])bufs);
                        written += res;
                        if (res != 0L) continue;
                        if (userBuffer != null) {
                            ByteBuffer copy = ByteBuffer.allocate(userBuffer.remaining());
                            copy.put(userBuffer);
                            copy.flip();
                            this.buffersToWrite = new ByteBuffer[]{buffer, copy};
                        } else {
                            this.buffersToWrite = bufs;
                        }
                        this.state &= 0xFFFFFFFB;
                        return;
                    } while (written < toWrite);
                    buffer.clear();
                }
            }
            finally {
                this.updateWrittenAsync(len);
            }
        }
    }

    void updateWritten(int len) throws IOException {
        this.written += (long)len;
        if (this.contentLength != null && this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    void updateWrittenAsync(int len) throws IOException {
        this.written += (long)len;
        if (this.contentLength != null && this.written >= this.contentLength) {
            this.state |= 1;
            if (this.flushBufferAsync()) {
                this.channel.shutdownWrites();
                this.state |= 8;
                if (!this.channel.flush()) {
                    this.resumeWrites();
                }
            }
        }
    }

    private void resumeWrites() {
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        this.underlyingConnectionChannel.getWriteSetter().set((ChannelListener)this.internalListener);
        this.underlyingConnectionChannel.resumeWrites();
    }

    private boolean flushBufferAsync() throws IOException {
        long toWrite;
        Buffer[] bufs = this.buffersToWrite;
        if (bufs == null) {
            ByteBuffer buffer = this.buffer();
            buffer.flip();
            bufs = new ByteBuffer[]{buffer};
        }
        if ((toWrite = Buffers.remaining((Buffer[])bufs)) == 0L) {
            this.buffer.clear();
            return true;
        }
        this.state |= 2;
        if (this.channel == null) {
            this.channel = this.servletResponse.getExchange().getResponseChannel();
        }
        long written = 0L;
        do {
            long res = this.channel.write((ByteBuffer[])bufs);
            written += res;
            if (res != 0L) continue;
            this.state &= 0xFFFFFFFB;
            this.buffersToWrite = bufs;
            return false;
        } while (written < toWrite);
        this.buffer.clear();
        return true;
    }

    ByteBuffer underlyingBuffer() {
        return this.buffer();
    }

    public void flush() throws IOException {
        if (this.listener == null) {
            if (Bits.anyAreSet((int)this.state, (int)1)) {
                throw UndertowServletMessages.MESSAGES.streamIsClosed();
            }
            if (this.buffer != null && this.buffer.position() != 0) {
                this.writeBufferBlocking();
            }
            if (this.channel == null) {
                this.channel = this.servletResponse.getExchange().getResponseChannel();
            }
            Channels.flushBlocking((SuspendableWriteChannel)this.channel);
        } else {
            long res;
            if (Bits.anyAreClear((int)this.state, (int)4)) {
                return;
            }
            if (this.channel == null) {
                this.channel = this.servletResponse.getExchange().getResponseChannel();
            }
            if (this.buffer == null || this.buffer.position() == 0) {
                this.channel.flush();
                return;
            }
            this.state |= 2;
            this.buffer.flip();
            do {
                res = this.channel.write(this.buffer);
                this.written += res;
            } while (this.buffer.hasRemaining() && res != 0L);
            if (!this.buffer.hasRemaining()) {
                this.channel.flush();
            }
            this.buffer.compact();
        }
    }

    private void writeBufferBlocking() throws IOException {
        this.buffer.flip();
        if (this.channel == null) {
            this.channel = this.servletResponse.getExchange().getResponseChannel();
        }
        Channels.writeBlocking((WritableByteChannel)this.channel, (ByteBuffer)this.buffer);
        this.buffer.clear();
        this.state |= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.listener == null) {
            if (Bits.anyAreSet((int)this.state, (int)1)) {
                return;
            }
            this.state |= 1;
            this.state &= 0xFFFFFFFB;
            if (Bits.allAreClear((int)this.state, (int)2) && this.channel == null) {
                if (this.buffer == null) {
                    this.servletResponse.setHeader(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.servletResponse.setHeader(Headers.CONTENT_LENGTH, "" + this.buffer.position());
                }
            }
            try {
                if (this.buffer != null) {
                    this.writeBufferBlocking();
                }
                if (this.channel == null) {
                    this.channel = this.servletResponse.getExchange().getResponseChannel();
                }
                StreamSinkChannel channel = this.channel;
                channel.shutdownWrites();
                this.state |= 8;
                Channels.flushBlocking((SuspendableWriteChannel)channel);
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.free();
                    this.buffer = null;
                } else {
                    this.buffer = null;
                }
            }
        } else {
            this.closeAsync();
        }
    }

    public void closeAsync() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        this.state |= 1;
        this.state &= 0xFFFFFFFB;
        if (Bits.allAreClear((int)this.state, (int)2) && this.channel == null) {
            if (this.buffer == null) {
                this.servletResponse.setHeader(Headers.CONTENT_LENGTH, "0");
            } else {
                this.servletResponse.setHeader(Headers.CONTENT_LENGTH, "" + this.buffer.position());
            }
        }
        if (this.channel == null) {
            this.channel = this.servletResponse.getExchange().getResponseChannel();
        }
        if (this.buffer != null && !this.flushBufferAsync()) {
            this.resumeWrites();
            return;
        }
        this.channel.shutdownWrites();
        this.state |= 8;
        if (!this.channel.flush()) {
            this.resumeWrites();
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        if (this.bufferSize != null) {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize);
            return this.buffer;
        }
        this.pooledBuffer = this.servletResponse.getExchange().getConnection().getBufferPool().allocate();
        this.buffer = (ByteBuffer)this.pooledBuffer.getResource();
        return this.buffer;
    }

    public void resetBuffer() {
        if (Bits.allAreClear((int)this.state, (int)2)) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.pooledBuffer = null;
            }
        } else {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.buffer = null;
    }

    public void setBufferSize(int size) {
        if (this.buffer != null) {
            throw UndertowServletMessages.MESSAGES.contentHasBeenWritten();
        }
        this.bufferSize = size;
    }

    public boolean isClosed() {
        return Bits.anyAreSet((int)this.state, (int)1);
    }

    public boolean isReady() {
        if (this.listener == null) {
            throw UndertowServletMessages.MESSAGES.streamNotInAsyncMode();
        }
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("writeListener");
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        HttpServletRequestImpl servletRequest = HttpServletRequestImpl.getRequestImpl((ServletRequest)this.servletResponse.getExchange().getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        if (!servletRequest.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = servletRequest.getAsyncContext();
        this.listener = writeListener;
        this.internalListener = new WriteChannelListener();
        this.underlyingConnectionChannel.getWriteSetter().set((ChannelListener)this.internalListener);
        this.underlyingConnectionChannel.resumeWrites();
    }

    static /* synthetic */ ByteBuffer[] access$402(ServletOutputStreamImpl x0, ByteBuffer[] x1) {
        x0.buffersToWrite = x1;
        return x1;
    }

    private class WriteChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private WriteChannelListener() {
        }

        public void handleEvent(final StreamSinkChannel theConnectionChannel) {
            theConnectionChannel.suspendWrites();
            ServletOutputStreamImpl.this.asyncContext.addAsyncTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Bits.anyAreSet((int)ServletOutputStreamImpl.this.state, (int)8)) {
                        try {
                            if (!ServletOutputStreamImpl.this.channel.flush()) {
                                theConnectionChannel.resumeWrites();
                            }
                            return;
                        }
                        catch (IOException e) {
                            WriteChannelListener.this.handleError(e);
                        }
                    }
                    if (ServletOutputStreamImpl.this.buffersToWrite != null) {
                        long toWrite = Buffers.remaining((Buffer[])ServletOutputStreamImpl.this.buffersToWrite);
                        long written = 0L;
                        do {
                            try {
                                long res = ServletOutputStreamImpl.this.channel.write(ServletOutputStreamImpl.this.buffersToWrite);
                                written += res;
                                if (res == 0L) {
                                    theConnectionChannel.resumeWrites();
                                    return;
                                }
                            }
                            catch (IOException e) {
                                WriteChannelListener.this.handleError(e);
                            }
                        } while (written < toWrite);
                        ServletOutputStreamImpl.access$402(ServletOutputStreamImpl.this, null);
                    }
                    if (Bits.anyAreSet((int)ServletOutputStreamImpl.this.state, (int)1)) {
                        try {
                            ServletOutputStreamImpl.this.channel.shutdownWrites();
                            ServletOutputStreamImpl.this.state |= 8;
                            if (!ServletOutputStreamImpl.this.channel.flush()) {
                                theConnectionChannel.resumeWrites();
                            }
                        }
                        catch (IOException e) {
                            WriteChannelListener.this.handleError(e);
                        }
                    } else {
                        ServletOutputStreamImpl.this.state |= 4;
                        try {
                            ServletOutputStreamImpl.this.state |= 16;
                            ThreadSetupAction.Handle handle = ServletOutputStreamImpl.this.threadSetupAction.setup(ServletOutputStreamImpl.this.servletResponse.getExchange());
                            try {
                                ServletOutputStreamImpl.this.listener.onWritePossible();
                            }
                            finally {
                                handle.tearDown();
                            }
                            theConnectionChannel.getWriteSetter().set((ChannelListener)WriteChannelListener.this);
                            if (!ServletOutputStreamImpl.this.isReady()) {
                                theConnectionChannel.resumeWrites();
                            }
                        }
                        catch (Throwable e) {
                            IoUtils.safeClose((Closeable)ServletOutputStreamImpl.this.channel);
                        }
                        finally {
                            ServletOutputStreamImpl.this.state &= -17;
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleError(IOException e) {
            try {
                ThreadSetupAction.Handle handle = ServletOutputStreamImpl.this.threadSetupAction.setup(ServletOutputStreamImpl.this.servletResponse.getExchange());
                try {
                    ServletOutputStreamImpl.this.listener.onError((Throwable)e);
                }
                finally {
                    handle.tearDown();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)ServletOutputStreamImpl.this.underlyingConnectionChannel);
            }
        }
    }
}

