/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.security.SingleConstraintMatch;
import java.util.List;

public class ServletAuthenticationConstraintHandler
extends AuthenticationConstraintHandler {
    public ServletAuthenticationConstraintHandler(HttpHandler next) {
        super(next);
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        List<SingleConstraintMatch> constraints = ((ServletAttachments)exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY)).getRequiredConstrains();
        boolean authenticationRequired = false;
        for (SingleConstraintMatch constraint : constraints) {
            if (constraint.getRequiredRoles().isEmpty()) {
                if (constraint.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.DENY) {
                    return false;
                }
                if (constraint.getEmptyRoleSemantic() != SecurityInfo.EmptyRoleSemantic.AUTHENTICATE) continue;
                authenticationRequired = true;
                continue;
            }
            authenticationRequired = true;
        }
        return authenticationRequired;
    }
}

