/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.security.SingleConstraintMatch;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements HttpHandler {
    private final HttpHandler next;

    public ServletSecurityRoleHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletAttachments servletAttachments = (ServletAttachments)exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY);
        List<SingleConstraintMatch> constraints = servletAttachments.getRequiredConstrains();
        SecurityContext sc = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(servletAttachments.getServletRequest());
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            this.next.handleRequest(exchange);
        } else if (constraints == null || constraints.isEmpty()) {
            this.next.handleRequest(exchange);
        } else {
            Account account = sc.getAuthenticatedAccount();
            for (SingleConstraintMatch constraint : constraints) {
                boolean found = false;
                Set<String> roleSet = constraint.getRequiredRoles();
                if (roleSet.isEmpty() && constraint.getEmptyRoleSemantic() != SecurityInfo.EmptyRoleSemantic.DENY) {
                    found = true;
                } else {
                    for (String role : roleSet) {
                        if (!account.isUserInRole(role)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                HttpServletResponse response = (HttpServletResponse)servletAttachments.getServletResponse();
                response.sendError(403);
                return;
            }
            this.next.handleRequest(exchange);
        }
    }
}

