/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpHandler;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentImpl
implements Deployment {
    private final DeploymentInfo deploymentInfo;
    private final List<Lifecycle> lifecycleObjects = new ArrayList<Lifecycle>();
    private volatile ApplicationListeners applicationListeners;
    private volatile ServletContextImpl servletContext;
    private volatile ServletInitialHandler servletHandler;
    private volatile ServletPathMatches servletPaths;
    private volatile CompositeThreadSetupAction threadSetupAction;
    private volatile ErrorPages errorPages;
    private volatile Map<String, String> mimeExtensionMappings;
    private volatile SessionManager sessionManager;

    public DeploymentImpl(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    void setApplicationListeners(ApplicationListeners applicationListeners) {
        this.applicationListeners = applicationListeners;
    }

    void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    @Override
    public ApplicationListeners getApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    @Override
    public HttpHandler getServletHandler() {
        return this.servletHandler;
    }

    void setServletHandler(ServletInitialHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    void addLifecycleObjects(Collection<Lifecycle> objects) {
        this.lifecycleObjects.addAll(objects);
    }

    void addLifecycleObjects(Lifecycle ... objects) {
        this.lifecycleObjects.addAll(Arrays.asList(objects));
    }

    void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public List<Lifecycle> getLifecycleObjects() {
        return Collections.unmodifiableList(this.lifecycleObjects);
    }

    @Override
    public ServletPathMatches getServletPaths() {
        return this.servletPaths;
    }

    void setServletPaths(ServletPathMatches servletPaths) {
        this.servletPaths = servletPaths;
    }

    @Override
    public CompositeThreadSetupAction getThreadSetupAction() {
        return this.threadSetupAction;
    }

    public void setThreadSetupAction(CompositeThreadSetupAction threadSetupAction) {
        this.threadSetupAction = threadSetupAction;
    }

    @Override
    public ErrorPages getErrorPages() {
        return this.errorPages;
    }

    public void setErrorPages(ErrorPages errorPages) {
        this.errorPages = errorPages;
    }

    @Override
    public Map<String, String> getMimeExtensionMappings() {
        return this.mimeExtensionMappings;
    }

    public void setMimeExtensionMappings(Map<String, String> mimeExtensionMappings) {
        this.mimeExtensionMappings = Collections.unmodifiableMap(new HashMap<String, String>(mimeExtensionMappings));
    }

    @Override
    public ServletDispatcher getServletDispatcher() {
        return this.servletHandler;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

