/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.websockets;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.websockets.spi.UpgradeCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Pool;

public class ServletWebSocketHttpExchange
implements WebSocketHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpServerExchange exchange;

    public ServletWebSocketHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.exchange = ServletRequestContext.requireCurrent().getOriginalRequest().getExchange();
    }

    public <T> void putAttachment(AttachmentKey<T> key, T value) {
        this.exchange.putAttachment(key, value);
    }

    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)this.exchange.getAttachment(key);
    }

    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public Map<String, List<String>> getRequestHeaders() {
        HashMap headers = new HashMap();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            Enumeration theHeaders = this.request.getHeaders(header);
            ArrayList vals = new ArrayList();
            headers.put(header, vals);
            while (theHeaders.hasMoreElements()) {
                vals.add(theHeaders.nextElement());
            }
        }
        return Collections.unmodifiableMap(headers);
    }

    public String getResponseHeader(String headerName) {
        return this.response.getHeader(headerName);
    }

    public Map<String, List<String>> getResponseHeaders() {
        HashMap headers = new HashMap();
        Collection headerNames = this.response.getHeaderNames();
        for (String header : headerNames) {
            headers.put(header, new ArrayList(this.response.getHeaders(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        for (String string : this.response.getHeaderNames()) {
            this.response.setHeader(string, null);
        }
        for (Map.Entry entry : headers.entrySet()) {
            for (String val : (List)entry.getValue()) {
                this.response.addHeader((String)entry.getKey(), val);
            }
        }
    }

    public void setResponseHeader(String headerName, String headerValue) {
        this.response.setHeader(headerName, headerValue);
    }

    public void setResponesCode(int code) {
        this.response.setStatus(code);
    }

    public void upgradeChannel(final UpgradeCallback upgradeCallback) {
        this.exchange.upgradeChannel(new ExchangeCompletionListener(){

            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                upgradeCallback.handleUpgrade(exchange.getConnection().getChannel(), exchange.getConnection().getBufferPool());
            }
        });
    }

    public IoFuture<Void> sendData(ByteBuffer data) {
        try {
            ServletOutputStream outputStream = this.response.getOutputStream();
            while (data.hasRemaining()) {
                outputStream.write((int)data.get());
            }
            return new FinishedIoFuture(null);
        }
        catch (IOException e) {
            ConcreteIoFuture ioFuture = new ConcreteIoFuture();
            ioFuture.setException(e);
            return ioFuture;
        }
    }

    public IoFuture<byte[]> readRequestData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int r;
            ServletInputStream in = this.request.getInputStream();
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                data.write(buf, 0, r);
            }
            return new FinishedIoFuture((Object)data.toByteArray());
        }
        catch (IOException e) {
            ConcreteIoFuture ioFuture = new ConcreteIoFuture();
            ioFuture.setException(e);
            return ioFuture;
        }
    }

    public void endExchange() {
    }

    public void close() {
        IoUtils.safeClose((Closeable)this.exchange.getConnection());
    }

    public String getRequestScheme() {
        return this.request.getScheme();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.exchange.getConnection().getBufferPool();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public Object getSession() {
        return this.request.getSession(false);
    }
}

