/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.NotificationHandler;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;

public class CachedAuthenticatedSessionHandler
implements HttpHandler {
    private static final String ATTRIBUTE_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    private final NotificationHandler NOTIFICATION_HANDLER = new SecurityNotificationHandler();
    private final AuthenticatedSessionManager SESSION_MANAGER = new ServletAuthenticatedSessionManager();
    private final HttpHandler next;
    private final ServletContextImpl servletContext;

    public CachedAuthenticatedSessionHandler(HttpHandler next, ServletContextImpl servletContext) {
        this.next = next;
        this.servletContext = servletContext;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        securityContext.registerNotificationHandler(this.NOTIFICATION_HANDLER);
        HttpSessionImpl session = this.servletContext.getSession(exchange, false);
        if (session != null) {
            exchange.putAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY, (Object)this.SESSION_MANAGER);
        }
        HttpHandlers.executeHandler((HttpHandler)this.next, (HttpServerExchange)exchange);
    }

    private class ServletAuthenticatedSessionManager
    implements AuthenticatedSessionManager {
        private ServletAuthenticatedSessionManager() {
        }

        public AuthenticatedSessionManager.AuthenticatedSession lookupSession(HttpServerExchange exchange) {
            HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(exchange, false);
            if (session != null) {
                return (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(ATTRIBUTE_NAME);
            }
            return null;
        }
    }

    private class SecurityNotificationHandler
    implements NotificationHandler {
        private SecurityNotificationHandler() {
        }

        public void handleNotification(SecurityNotification notification) {
            SecurityNotification.EventType eventType = notification.getEventType();
            switch (eventType) {
                case AUTHENTICATED: {
                    if (!notification.isCacheable()) break;
                    HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), true);
                    session.setAttribute(ATTRIBUTE_NAME, new AuthenticatedSessionManager.AuthenticatedSession(notification.getAccount(), notification.getMechanism()));
                    break;
                }
                case LOGGED_OUT: {
                    HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), false);
                    if (session == null) break;
                    session.removeAttribute(ATTRIBUTE_NAME);
                }
            }
        }
    }
}

