/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.http.Part;

public class PartImpl
implements Part {
    private final HttpString FILE_NAME = HttpString.tryFromString((String)"File-Name");
    private final String name;
    private final FormData.FormValue formValue;

    public PartImpl(String name, FormData.FormValue formValue) {
        this.name = name;
        this.formValue = formValue;
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.formValue.getFile()));
    }

    public String getContentType() {
        return this.formValue.getHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.formValue.getFileName();
    }

    public long getSize() {
        if (this.formValue.isFile()) {
            return this.formValue.getFile().length();
        }
        return this.formValue.getValue().length();
    }

    public void write(String fileName) throws IOException {
        throw new IllegalStateException();
    }

    public void delete() throws IOException {
        if (!this.formValue.getFile().delete()) {
            throw UndertowServletMessages.MESSAGES.deleteFailed(this.formValue.getFile());
        }
    }

    public String getHeader(String name) {
        return this.formValue.getHeaders().getFirst(new HttpString(name));
    }

    public Collection<String> getHeaders(String name) {
        HeaderValues values = this.formValue.getHeaders().get(new HttpString(name));
        return values == null ? Collections.emptyList() : values;
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> ret = new HashSet<String>();
        for (HttpString i : this.formValue.getHeaders().getHeaderNames()) {
            ret.add(i.toString());
        }
        return ret;
    }
}

