/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.Version;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.spec.FilterRegistrationImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletRegistrationImpl;
import io.undertow.servlet.spec.SessionCookieConfigImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class ServletContextImpl
implements ServletContext {
    private final ServletContainer servletContainer;
    private final Deployment deployment;
    private final DeploymentInfo deploymentInfo;
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final SessionCookieConfigImpl sessionCookieConfig;
    private final AttachmentKey<HttpSessionImpl> sessionAttachmentKey = AttachmentKey.create(HttpSessionImpl.class);

    public ServletContextImpl(ServletContainer servletContainer, Deployment deployment) {
        this.servletContainer = servletContainer;
        this.deployment = deployment;
        this.deploymentInfo = deployment.getDeploymentInfo();
        this.sessionCookieConfig = new SessionCookieConfigImpl();
        this.attributes.putAll(deployment.getDeploymentInfo().getServletContextAttributes());
    }

    public String getContextPath() {
        return this.deploymentInfo.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        DeploymentManager deploymentByPath = this.servletContainer.getDeploymentByPath(uripath);
        if (deploymentByPath == null) {
            return null;
        }
        return deploymentByPath.getDeployment().getServletContext();
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return this.deploymentInfo.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.deploymentInfo.getMinorVersion();
    }

    public String getMimeType(String file) {
        int pos = file.lastIndexOf(46);
        if (pos == -1) {
            return this.deployment.getMimeExtensionMappings().get(file);
        }
        return this.deployment.getMimeExtensionMappings().get(file.substring(pos + 1));
    }

    public Set<String> getResourcePaths(String path) {
        File resource = this.deploymentInfo.getResourceLoader().getResource(path);
        if (resource == null || !resource.isDirectory()) {
            return null;
        }
        String first = path.charAt(path.length() - 1) == '/' ? path : path + '/';
        HashSet<String> resources = new HashSet<String>();
        for (String res : resource.list()) {
            resources.add(first + res);
        }
        return resources;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw UndertowServletMessages.MESSAGES.pathMustStartWithSlash(path);
        }
        File resource = this.deploymentInfo.getResourceLoader().getResource(path);
        if (resource == null) {
            return null;
        }
        return resource.toURL();
    }

    public InputStream getResourceAsStream(String path) {
        File resource = this.deploymentInfo.getResourceLoader().getResource(path);
        if (resource == null) {
            return null;
        }
        try {
            return new BufferedInputStream(new FileInputStream(resource));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcherImpl(path, this.deployment.getServletContext());
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ServletChain chain = this.deployment.getServletPaths().getServletHandlerByName(name);
        if (chain != null) {
            return new RequestDispatcherImpl(chain, this.deployment.getServletContext());
        }
        return null;
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.deployment.getServletPaths().getServletHandlerByName(name).getManagedServlet().getServlet().getInstance();
    }

    public Enumeration<Servlet> getServlets() {
        return EmptyEnumeration.instance();
    }

    public Enumeration<String> getServletNames() {
        return EmptyEnumeration.instance();
    }

    public void log(String msg) {
        UndertowServletLogger.ROOT_LOGGER.info(msg);
    }

    public void log(Exception exception, String msg) {
        UndertowServletLogger.ROOT_LOGGER.error(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        UndertowServletLogger.ROOT_LOGGER.error(message, throwable);
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getServerInfo() {
        return Version.getVersionString();
    }

    public String getInitParameter(String name) {
        return this.deploymentInfo.getInitParameters().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.deploymentInfo.getInitParameters().keySet().iterator());
    }

    public boolean setInitParameter(String name, String value) {
        if (this.deploymentInfo.getInitParameters().containsKey(name)) {
            return false;
        }
        this.deploymentInfo.addInitParameter(name, value);
        return true;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object object) {
        if (object == null) {
            Object existing = this.attributes.remove(name);
            if (existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, existing);
            }
        } else {
            Object existing = this.attributes.put(name, object);
            if (existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeReplaced(name, existing);
            } else {
                this.deployment.getApplicationListeners().servletContextAttributeAdded(name, object);
            }
        }
    }

    public void removeAttribute(String name) {
        Object exiting = this.attributes.remove(name);
        this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, exiting);
    }

    public String getServletContextName() {
        return this.deploymentInfo.getDisplayName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            ServletInfo servlet = new ServletInfo(servletName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.deploymentInfo.addServlet(servlet);
            return new ServletRegistrationImpl(servlet, this.deploymentInfo);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        ServletInfo s = new ServletInfo(servletName, servlet.getClass(), new ImmediateInstanceFactory<Servlet>(servlet));
        this.deploymentInfo.addServlet(s);
        return new ServletRegistrationImpl(s, this.deploymentInfo);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        ServletInfo servlet = new ServletInfo(servletName, servletClass);
        this.deploymentInfo.addServlet(servlet);
        return new ServletRegistrationImpl(servlet, this.deploymentInfo);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        ServletInfo servlet = this.deploymentInfo.getServlets().get(servletName);
        return new ServletRegistrationImpl(servlet, this.deploymentInfo);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        HashMap<String, ServletRegistrationImpl> ret = new HashMap<String, ServletRegistrationImpl>();
        for (Map.Entry<String, ServletInfo> entry : this.deploymentInfo.getServlets().entrySet()) {
            ret.put(entry.getKey(), new ServletRegistrationImpl(entry.getValue(), this.deploymentInfo));
        }
        return ret;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        try {
            FilterInfo filter = new FilterInfo(filterName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.deploymentInfo.addFilter(filter);
            return new FilterRegistrationImpl(filter, this.deploymentInfo);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        FilterInfo f = new FilterInfo(filterName, filter.getClass(), new ImmediateInstanceFactory<Filter>(filter));
        this.deploymentInfo.addFilter(f);
        return new FilterRegistrationImpl(f, this.deploymentInfo);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        FilterInfo filter = new FilterInfo(filterName, filterClass);
        this.deploymentInfo.addFilter(filter);
        return new FilterRegistrationImpl(filter, this.deploymentInfo);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        FilterInfo filterInfo = this.deploymentInfo.getFilters().get(filterName);
        if (filterInfo == null) {
            return null;
        }
        return new FilterRegistrationImpl(filterInfo, this.deploymentInfo);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        HashMap<String, FilterRegistrationImpl> ret = new HashMap<String, FilterRegistrationImpl>();
        for (Map.Entry<String, FilterInfo> entry : this.deploymentInfo.getFilters().entrySet()) {
            ret.put(entry.getKey(), new FilterRegistrationImpl(entry.getValue(), this.deploymentInfo));
        }
        return ret;
    }

    public SessionCookieConfigImpl getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
        try {
            Class<?> clazz = this.deploymentInfo.getClassLoader().loadClass(className);
            this.addListener(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        ListenerInfo listener = new ListenerInfo(t.getClass(), new ImmediateInstanceFactory<T>(t));
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener));
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        InstanceFactory<? extends EventListener> factory = null;
        try {
            factory = this.deploymentInfo.getClassIntrospecter().createInstanceFactory(listenerClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        ListenerInfo listener = new ListenerInfo(listenerClass, factory);
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener));
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.deploymentInfo.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.deploymentInfo.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
    }

    public HttpSessionImpl getSession(HttpServerExchange exchange, boolean create) {
        SessionCookieConfigImpl c = this.getSessionCookieConfig();
        HttpSessionImpl httpSession = (HttpSessionImpl)exchange.getAttachment(this.sessionAttachmentKey);
        if (httpSession != null && httpSession.isInvalid()) {
            exchange.removeAttachment(this.sessionAttachmentKey);
            httpSession = null;
        }
        if (httpSession == null) {
            SessionManager sessionManager = this.deploymentInfo.getSessionManager();
            Session session = sessionManager.getSession(exchange, (SessionConfig)c);
            if (session != null) {
                httpSession = new HttpSessionImpl(session, this, this.getDeployment().getApplicationListeners(), exchange, false);
                exchange.putAttachment(this.sessionAttachmentKey, (Object)httpSession);
            } else if (create) {
                Session newSession = sessionManager.createSession(exchange, (SessionConfig)c);
                httpSession = new HttpSessionImpl(newSession, this, this.getDeployment().getApplicationListeners(), exchange, true);
                exchange.putAttachment(this.sessionAttachmentKey, (Object)httpSession);
                this.getDeployment().getApplicationListeners().sessionCreated(httpSession);
            }
        }
        return httpSession;
    }

    public void updateSessionAccessTime(HttpServerExchange exchange) {
        HttpSessionImpl httpSession = this.getSession(exchange, false);
        if (httpSession != null) {
            httpSession.getSession().requestDone(exchange);
        }
    }

    public Deployment getDeployment() {
        return this.deployment;
    }
}

