/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.Closeable;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.xnio.IoUtils;

public class ServletInitialHandler
implements HttpHandler,
ServletDispatcher {
    private final HttpHandler next;
    private final CompositeThreadSetupAction setupAction;
    private final ServletContextImpl servletContext;
    private final ApplicationListeners listeners;
    private final ServletPathMatches paths;

    public ServletInitialHandler(ServletPathMatches paths, HttpHandler next, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext) {
        this.next = next;
        this.setupAction = setupAction;
        this.servletContext = servletContext;
        this.paths = paths;
        this.listeners = servletContext.getDeployment().getApplicationListeners();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        String path = exchange.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, this.servletContext);
        HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, this.servletContext);
        exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, (Object)request);
        exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, (Object)response);
        try {
            exchange.startBlocking((BlockingHttpExchange)new ServletBlockingHttpExchange(exchange));
            exchange.putAttachment(ServletAttachments.SERVLET_PATH_MATCH, (Object)info);
            this.dispatchRequest(exchange, info, request, response, DispatcherType.REQUEST);
        }
        catch (Throwable t) {
            UndertowLogger.REQUEST_LOGGER.errorf(t, "Internal error handling servlet request %s", (Object)exchange.getRequestURI());
            exchange.endExchange();
        }
    }

    @Override
    public void dispatchToPath(HttpServerExchange exchange, ServletPathMatch pathInfo, DispatcherType dispatcherType) throws Exception {
        HttpServletRequestImpl req = HttpServletRequestImpl.getRequestImpl((ServletRequest)exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        HttpServletResponseImpl resp = HttpServletResponseImpl.getResponseImpl((ServletResponse)exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY));
        exchange.putAttachment(ServletAttachments.SERVLET_PATH_MATCH, (Object)pathInfo);
        this.dispatchRequest(exchange, pathInfo, req, resp, dispatcherType);
    }

    @Override
    public void dispatchToServlet(HttpServerExchange exchange, ServletChain servletchain, DispatcherType dispatcherType) throws Exception {
        HttpServletRequestImpl req = HttpServletRequestImpl.getRequestImpl((ServletRequest)exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        HttpServletResponseImpl resp = HttpServletResponseImpl.getResponseImpl((ServletResponse)exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY));
        this.dispatchRequest(exchange, servletchain, req, resp, dispatcherType);
    }

    public void dispatchRequest(HttpServerExchange exchange, ServletChain servletChain, HttpServletRequestImpl request, HttpServletResponseImpl response, DispatcherType dispatcherType) throws Exception {
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, (Object)dispatcherType);
        exchange.putAttachment(ServletAttachments.CURRENT_SERVLET, (Object)servletChain);
        if (dispatcherType == DispatcherType.REQUEST || dispatcherType == DispatcherType.ASYNC) {
            this.handleFirstRequest(exchange, servletChain, request, response);
        } else {
            this.next.handleRequest(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFirstRequest(HttpServerExchange exchange, ServletChain servletChain, HttpServletRequestImpl request, HttpServletResponseImpl response) throws Exception {
        ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
        try {
            String location;
            this.listeners.requestInitialized((ServletRequest)request);
            this.next.handleRequest(exchange);
            if (!exchange.isResponseStarted() && exchange.getResponseCode() >= 400 && !exchange.isDispatched() && (location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(exchange.getResponseCode())) != null) {
                RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                dispatcher.error((ServletRequest)request, (ServletResponse)response, servletChain.getManagedServlet().getServletInfo().getName());
            }
        }
        catch (Throwable t) {
            if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                exchange.unDispatch();
                request.getAsyncContextInternal().handleError(t);
            } else if (!exchange.isResponseStarted()) {
                exchange.setResponseCode(500);
                exchange.getResponseHeaders().clear();
                String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                if (location == null && t instanceof ServletException) {
                    location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t.getCause());
                }
                if (location != null) {
                    RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                    try {
                        dispatcher.error((ServletRequest)request, (ServletResponse)response, servletChain.getManagedServlet().getServletInfo().getName(), t);
                    }
                    catch (Exception e) {
                        UndertowLogger.REQUEST_LOGGER.errorf((Throwable)e, "Exception while generating error page %s", (Object)location);
                    }
                } else {
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Servlet request failed %s", (Object)exchange);
                }
            }
        }
        finally {
            handle.tearDown();
        }
        request.getServletContext().getDeployment().getApplicationListeners().requestDestroyed((ServletRequest)request);
        if (!exchange.isDispatched()) {
            response.responseDone();
            FormDataParser parser = (FormDataParser)exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            IoUtils.safeClose((Closeable)parser);
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }
}

