/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowMessages;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;

public class ServletRegistrationImpl
implements ServletRegistration,
ServletRegistration.Dynamic {
    private final ServletInfo servletInfo;
    private final DeploymentInfo deploymentInfo;

    public ServletRegistrationImpl(ServletInfo servletInfo, DeploymentInfo deploymentInfo) {
        this.servletInfo = servletInfo;
        this.deploymentInfo = deploymentInfo;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.servletInfo.setLoadOnStartup(loadOnStartup);
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        if (constraint == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("constraint");
        }
        HashSet<String> urlPatterns = new HashSet<String>();
        for (SecurityConstraint sc : this.deploymentInfo.getSecurityConstraints()) {
            for (WebResourceCollection webResources : sc.getWebResourceCollections()) {
                urlPatterns.addAll(webResources.getUrlPatterns());
            }
        }
        HashSet<String> ret = new HashSet<String>();
        for (String url : this.servletInfo.getMappings()) {
            if (!urlPatterns.contains(url)) continue;
            ret.add(url);
        }
        ServletSecurityInfo info = new ServletSecurityInfo();
        this.servletInfo.setServletSecurityInfo(info);
        ((ServletSecurityInfo)((ServletSecurityInfo)info.setTransportGuaranteeType(constraint.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).setEmptyRoleSemantic(constraint.getEmptyRoleSemantic())).addRolesAllowed(constraint.getRolesAllowed());
        for (HttpMethodConstraintElement methodConstraint : constraint.getHttpMethodConstraints()) {
            info.addHttpMethodSecurityInfo((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setTransportGuaranteeType(methodConstraint.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).setMethod(methodConstraint.getMethodName()).setEmptyRoleSemantic(methodConstraint.getEmptyRoleSemantic())).addRolesAllowed(methodConstraint.getRolesAllowed()));
        }
        return ret;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.servletInfo.setMultipartConfig(multipartConfig);
    }

    public void setRunAsRole(String roleName) {
        this.servletInfo.setRunAs(roleName);
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.servletInfo.setAsyncSupported(isAsyncSupported);
    }

    public Set<String> addMapping(String ... urlPatterns) {
        HashSet<String> ret = new HashSet<String>();
        HashSet<String> existing = new HashSet<String>();
        for (ServletInfo s : this.deploymentInfo.getServlets().values()) {
            if (s.getName().equals(this.servletInfo.getName())) continue;
            existing.addAll(s.getMappings());
        }
        for (String pattern : urlPatterns) {
            if (!existing.contains(pattern)) continue;
            ret.add(pattern);
        }
        if (ret.isEmpty()) {
            for (String pattern : urlPatterns) {
                if (this.servletInfo.getMappings().contains(pattern)) continue;
                this.servletInfo.addMapping(pattern);
            }
        }
        return ret;
    }

    public Collection<String> getMappings() {
        return this.servletInfo.getMappings();
    }

    public String getRunAsRole() {
        return this.servletInfo.getRunAs();
    }

    public String getName() {
        return this.servletInfo.getName();
    }

    public String getClassName() {
        return this.servletInfo.getServletClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        if (this.servletInfo.getInitParams().containsKey(name)) {
            return false;
        }
        this.servletInfo.addInitParam(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.servletInfo.getInitParams().get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public Map<String, String> getInitParameters() {
        return this.servletInfo.getInitParams();
    }
}

