/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletDebugPageHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import io.undertow.util.RedirectBuilder;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;

public class ServletInitialHandler
implements HttpHandler,
ServletDispatcher {
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.servlet.CREATE_INITIAL_HANDLER");
    private final HttpHandler next;
    private final CompositeThreadSetupAction setupAction;
    private final ServletContextImpl servletContext;
    private final ApplicationListeners listeners;
    private final ServletPathMatches paths;

    public ServletInitialHandler(ServletPathMatches paths, HttpHandler next, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext) {
        this.next = next;
        this.setupAction = setupAction;
        this.servletContext = servletContext;
        this.paths = paths;
        this.listeners = servletContext.getDeployment().getApplicationListeners();
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        if (this.isForbiddenPath(path)) {
            exchange.setResponseCode(404);
            return;
        }
        final ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        if (info.getType() == ServletPathMatch.Type.REDIRECT) {
            exchange.setResponseCode(302);
            exchange.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect((HttpServerExchange)exchange, (String)(exchange.getRelativePath() + "/"), (boolean)true));
            return;
        }
        if (info.getType() == ServletPathMatch.Type.REWRITE) {
            exchange.setRelativePath(exchange.getRelativePath() + info.getRewriteLocation());
            exchange.setRequestURI(exchange.getRequestURI() + info.getRewriteLocation());
            exchange.setRequestPath(exchange.getRequestPath() + info.getRewriteLocation());
        }
        HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, this.servletContext);
        HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, this.servletContext);
        final ServletRequestContext servletRequestContext = new ServletRequestContext(this.servletContext.getDeployment(), request, response, info);
        if (info.getServletChain().getManagedServlet().getMaxRequestSize() > 0L) {
            exchange.setMaxEntitySize(info.getServletChain().getManagedServlet().getMaxRequestSize());
        }
        exchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
        exchange.startBlocking((BlockingHttpExchange)new ServletBlockingHttpExchange(exchange));
        servletRequestContext.setServletPathMatch(info);
        Executor executor = info.getServletChain().getExecutor();
        if (executor == null) {
            executor = this.servletContext.getDeployment().getExecutor();
        }
        if (exchange.isInIoThread() || executor != null) {
            exchange.dispatch(executor, new HttpHandler(){

                public void handleRequest(final HttpServerExchange exchange) throws Exception {
                    if (System.getSecurityManager() == null) {
                        ServletInitialHandler.this.dispatchRequest(exchange, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
                    } else {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                ServletInitialHandler.this.dispatchRequest(exchange, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
                                return null;
                            }
                        });
                    }
                }
            });
        } else {
            this.dispatchRequest(exchange, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
        }
    }

    private boolean isForbiddenPath(String path) {
        return path.equalsIgnoreCase("/meta-inf/") || path.regionMatches(true, 0, "/web-inf/", 0, "/web-inf/".length());
    }

    @Override
    public void dispatchToPath(HttpServerExchange exchange, ServletPathMatch pathInfo, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletPathMatch(pathInfo);
        this.dispatchRequest(exchange, servletRequestContext, pathInfo.getServletChain(), dispatcherType);
    }

    @Override
    public void dispatchToServlet(HttpServerExchange exchange, ServletChain servletchain, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        this.dispatchRequest(exchange, servletRequestContext, servletchain, dispatcherType);
    }

    @Override
    public void dispatchMockRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ByteBufferSlicePool bufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 1024, 1024);
        MockServerConnection connection = new MockServerConnection((Pool)bufferPool);
        HttpServerExchange exchange = new HttpServerExchange((ServerConnection)connection);
        exchange.setRequestScheme(request.getScheme());
        exchange.setRequestMethod(new HttpString(request.getMethod()));
        exchange.setProtocol(Protocols.HTTP_1_0);
        exchange.setResolvedPath(request.getContextPath());
        String relative = request.getPathInfo() == null ? request.getServletPath() : request.getServletPath() + request.getPathInfo();
        exchange.setRelativePath(relative);
        ServletPathMatch info = this.paths.getServletHandlerByPath(request.getServletPath());
        HttpServletResponseImpl oResponse = new HttpServletResponseImpl(exchange, this.servletContext);
        HttpServletRequestImpl oRequest = new HttpServletRequestImpl(exchange, this.servletContext);
        ServletRequestContext servletRequestContext = new ServletRequestContext(this.servletContext.getDeployment(), oRequest, oResponse, info);
        servletRequestContext.setServletRequest((ServletRequest)request);
        servletRequestContext.setServletResponse((ServletResponse)response);
        if (info.getServletChain().getManagedServlet().getMaxRequestSize() > 0L) {
            exchange.setMaxEntitySize(info.getServletChain().getManagedServlet().getMaxRequestSize());
        }
        exchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
        exchange.startBlocking((BlockingHttpExchange)new ServletBlockingHttpExchange(exchange));
        servletRequestContext.setServletPathMatch(info);
        try {
            this.dispatchRequest(exchange, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void dispatchRequest(HttpServerExchange exchange, ServletRequestContext servletRequestContext, ServletChain servletChain, DispatcherType dispatcherType) throws Exception {
        servletRequestContext.setDispatcherType(dispatcherType);
        servletRequestContext.setCurrentServlet(servletChain);
        if (dispatcherType == DispatcherType.REQUEST || dispatcherType == DispatcherType.ASYNC) {
            this.handleFirstRequest(exchange, servletChain, servletRequestContext, servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse());
        } else {
            this.next.handleRequest(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFirstRequest(HttpServerExchange exchange, ServletChain servletChain, ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response) throws Exception {
        ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
        try {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
            try {
                this.listeners.requestInitialized(request);
                this.next.handleRequest(exchange);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    UndertowLogger.REQUEST_IO_LOGGER.debugf(t, "Exception handling request to %s", (Object)exchange.getRequestURI());
                } else {
                    UndertowLogger.REQUEST_LOGGER.exceptionHandlingRequest(t, exchange.getRequestURI());
                }
                if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                    exchange.unDispatch();
                    servletRequestContext.getOriginalRequest().getAsyncContextInternal().handleError(t);
                } else if (!exchange.isResponseStarted()) {
                    response.reset();
                    exchange.setResponseCode(500);
                    exchange.getResponseHeaders().clear();
                    String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                    if (location != null) {
                        RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                        try {
                            dispatcher.error(request, response, servletChain.getManagedServlet().getServletInfo().getName(), t);
                        }
                        catch (Exception e) {
                            UndertowLogger.REQUEST_LOGGER.exceptionGeneratingErrorPage(e, location);
                        }
                    } else if (servletRequestContext.displayStackTraces()) {
                        ServletDebugPageHandler.handleRequest(exchange, servletRequestContext, t);
                    } else if (response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendError(500);
                    } else {
                        servletRequestContext.getOriginalResponse().sendError(500);
                    }
                }
            }
            finally {
                this.listeners.requestDestroyed(request);
            }
            if (!exchange.isDispatched() && !(exchange.getConnection() instanceof MockServerConnection)) {
                servletRequestContext.getOriginalResponse().responseDone();
            }
        }
        finally {
            try {
                handle.tearDown();
            }
            finally {
                ServletRequestContext.clearCurrentServletAttachments();
            }
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    private static class MockServerConnection
    extends AbstractAttachable
    implements ServerConnection {
        private final Pool<ByteBuffer> bufferPool;
        private SSLSessionInfo sslSessionInfo;

        private MockServerConnection(Pool<ByteBuffer> bufferPool) {
            this.bufferPool = bufferPool;
        }

        public Pool<ByteBuffer> getBufferPool() {
            return this.bufferPool;
        }

        public XnioWorker getWorker() {
            return null;
        }

        public XnioIoThread getIoThread() {
            return null;
        }

        public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
            throw new IllegalStateException();
        }

        public boolean isOpen() {
            return true;
        }

        public boolean supportsOption(Option<?> option) {
            return false;
        }

        public <T> T getOption(Option<T> option) throws IOException {
            return null;
        }

        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public SocketAddress getPeerAddress() {
            return null;
        }

        public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
            return null;
        }

        public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
            return null;
        }

        public OptionMap getUndertowOptions() {
            return OptionMap.EMPTY;
        }

        public int getBufferSize() {
            return 1024;
        }

        public SSLSessionInfo getSslSessionInfo() {
            return this.sslSessionInfo;
        }

        public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
            this.sslSessionInfo = sessionInfo;
        }

        public void addCloseListener(ServerConnection.CloseListener listener) {
        }

        public StreamConnection upgradeChannel() {
            return null;
        }

        public ConduitStreamSinkChannel getSinkChannel() {
            return null;
        }

        public ConduitStreamSourceChannel getSourceChannel() {
            return new ConduitStreamSourceChannel(null, null);
        }
    }
}

