/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.spec.WebConnectionImpl;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements ExchangeCompletionListener {
    private final InstanceHandle<T> instance;

    public ServletUpgradeListener(InstanceHandle<T> instance) {
        this.instance = instance;
    }

    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        final StreamConnection channel = exchange.getConnection().getChannel();
        exchange.getConnection().addCloseListener(new HttpServerConnection.CloseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closed(HttpServerConnection connection) {
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).destroy();
                }
                finally {
                    ServletUpgradeListener.this.instance.release();
                }
            }
        });
        exchange.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).init((WebConnection)new WebConnectionImpl(channel));
            }
        });
    }
}

