/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.SingleConstraintMatch;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Map<String, Set<String>> principalVsRoleMap;

    public ServletSecurityRoleHandler(HttpHandler next, Map<String, Set<String>> principalVsRoleMap) {
        this.next = next;
        this.principalVsRoleMap = principalVsRoleMap;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        List<SingleConstraintMatch> constraints = servletRequestContext.getRequiredConstrains();
        SecurityContext sc = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        ServletRequest request = servletRequestContext.getServletRequest();
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            this.next.handleRequest(exchange);
        } else if (constraints == null || constraints.isEmpty()) {
            this.next.handleRequest(exchange);
        } else {
            Account account = sc.getAuthenticatedAccount();
            for (SingleConstraintMatch constraint : constraints) {
                boolean found = false;
                Set<String> roleSet = constraint.getRequiredRoles();
                if (roleSet.isEmpty() && constraint.getEmptyRoleSemantic() != SecurityInfo.EmptyRoleSemantic.DENY) {
                    found = true;
                } else if (account != null) {
                    Set<String> roles = this.principalVsRoleMap.get(account.getPrincipal().getName());
                    for (String role : roleSet) {
                        if (roles != null && roles.contains(role)) {
                            found = true;
                            break;
                        }
                        if (!account.isUserInRole(role)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
                response.sendError(403);
                return;
            }
            this.next.handleRequest(exchange);
        }
    }
}

