/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class SSLInformationAssociationHandler
implements HttpHandler {
    private final HttpHandler next;

    public SSLInformationAssociationHandler(HttpHandler next) {
        this.next = next;
    }

    public static int getKeyLenght(String cipherSuite) {
        if (cipherSuite == null) {
            return 0;
        }
        if (cipherSuite.contains("WITH_AES_256_")) {
            return 256;
        }
        if (cipherSuite.contains("WITH_RC4_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_AES_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_RC4_40_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_3DES_EDE_CBC_")) {
            return 168;
        }
        if (cipherSuite.contains("WITH_IDEA_CBC_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_RC2_CBC_40_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_DES40_CBC_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_DES_CBC_")) {
            return 56;
        }
        return 0;
    }

    private X509Certificate[] getCerts(SSLSessionInfo session) {
        try {
            javax.security.cert.X509Certificate[] javaxCerts = session.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            X509Certificate[] javaCerts = new X509Certificate[javaxCerts.length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < javaxCerts.length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequest request = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletRequest();
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl != null) {
            X509Certificate[] certs;
            request.setAttribute("javax.servlet.request.cipher_suite", (Object)ssl.getCipherSuite());
            request.setAttribute("javax.servlet.request.key_size", (Object)SSLInformationAssociationHandler.getKeyLenght(ssl.getCipherSuite()));
            request.setAttribute("javax.servlet.request.ssl_session_id", (Object)ssl.getSessionId());
            if (request instanceof HttpServletRequest && "CLIENT_CERT".equals(((HttpServletRequest)request).getAuthType()) && (certs = this.getCerts(ssl)) != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs);
            }
        }
        this.next.handleRequest(exchange);
    }
}

