/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletCookieAdaptor;
import io.undertow.servlet.spec.ServletOutputStreamImpl;
import io.undertow.servlet.spec.ServletPrintWriter;
import io.undertow.servlet.spec.ServletPrintWriterDelegate;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class HttpServletResponseImpl
implements HttpServletResponse {
    private final HttpServerExchange exchange;
    private final ServletContextImpl originalServletContext;
    private volatile ServletContextImpl servletContext;
    private ServletOutputStreamImpl servletOutputStream;
    private ResponseState responseState = ResponseState.NONE;
    private PrintWriter writer;
    private Integer bufferSize;
    private long contentLength = -1L;
    private boolean insideInclude = false;
    private Locale locale;
    private boolean responseDone = false;
    private boolean ignoredFlushPerformed = false;
    private boolean charsetSet = false;
    private String contentType;
    private String charset;

    public HttpServletResponseImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
        this.originalServletContext = servletContext;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public void addCookie(javax.servlet.http.Cookie cookie) {
        if (this.insideInclude) {
            return;
        }
        ServletCookieAdaptor servletCookieAdaptor = new ServletCookieAdaptor(cookie);
        if (cookie.getVersion() == 0) {
            servletCookieAdaptor.setVersion(this.servletContext.getDeployment().getDeploymentInfo().getDefaultCookieVersion());
        }
        this.exchange.setResponseCookie((Cookie)servletCookieAdaptor);
    }

    public boolean containsHeader(String name) {
        return this.exchange.getResponseHeaders().contains(name);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.responseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.resetBuffer();
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.setResponseCode(sc);
        String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(sc);
        if (location != null) {
            RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(location, this.servletContext);
            ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            try {
                requestDispatcher.error(servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse(), ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet().getManagedServlet().getServletInfo().getName(), msg);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        } else if (msg != null) {
            this.setContentType("text/html");
            this.getWriter().write("<html><head><title>Error</title></head><body>" + msg + "</body></html>");
            this.getWriter().close();
        }
        this.responseDone();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, StatusCodes.getReason((int)sc));
    }

    public void sendRedirect(String location) throws IOException {
        if (this.responseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.resetBuffer();
        this.setStatus(302);
        if (location.contains("://")) {
            this.exchange.getResponseHeaders().put(Headers.LOCATION, location);
        } else {
            String realPath;
            if (location.startsWith("/")) {
                realPath = location;
            } else {
                String current = this.exchange.getRelativePath();
                int lastSlash = current.lastIndexOf("/");
                if (lastSlash != -1) {
                    current = current.substring(0, lastSlash + 1);
                }
                realPath = this.servletContext.getContextPath() + CanonicalPathUtils.canonicalize((String)(current + location));
            }
            String loc = this.exchange.getRequestScheme() + "://" + this.exchange.getHostAndPort() + realPath;
            this.exchange.getResponseHeaders().put(Headers.LOCATION, loc);
        }
        this.responseDone();
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, DateUtils.toDateString((Date)new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, DateUtils.toDateString((Date)new Date(date)));
    }

    public void setHeader(String name, String value) {
        this.setHeader(new HttpString(name), value);
    }

    public void setHeader(HttpString name, String value) {
        if (this.insideInclude || this.ignoredFlushPerformed) {
            return;
        }
        this.exchange.getResponseHeaders().put(name, value);
    }

    public void addHeader(String name, String value) {
        this.addHeader(new HttpString(name), value);
    }

    public void addHeader(HttpString name, String value) {
        if (this.insideInclude || this.ignoredFlushPerformed) {
            return;
        }
        this.exchange.getResponseHeaders().add(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        if (this.insideInclude) {
            return;
        }
        if (this.responseStarted()) {
            return;
        }
        this.exchange.setResponseCode(sc);
    }

    public void setStatus(int sc, String sm) {
        if (this.insideInclude) {
            return;
        }
        this.setStatus(sc);
    }

    public int getStatus() {
        return this.exchange.getResponseCode();
    }

    public String getHeader(String name) {
        return this.exchange.getResponseHeaders().getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        return new ArrayList<String>((Collection<String>)this.exchange.getResponseHeaders().get(name));
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getResponseHeaders().getHeaderNames()) {
            headers.add(i.toString());
        }
        return headers;
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            return this.servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding();
        }
        return this.charset;
    }

    public String getContentType() {
        if (this.contentType != null) {
            if (this.charsetSet) {
                return this.contentType + ";charset=" + this.getCharacterEncoding();
            }
            return this.contentType;
        }
        return null;
    }

    public ServletOutputStream getOutputStream() {
        if (this.responseState == ResponseState.WRITER) {
            throw UndertowServletMessages.MESSAGES.getWriterAlreadyCalled();
        }
        this.responseState = ResponseState.STREAM;
        this.createOutputStream();
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (!this.charsetSet) {
                this.setCharacterEncoding(this.getCharacterEncoding());
            }
            if (this.responseState == ResponseState.STREAM) {
                throw UndertowServletMessages.MESSAGES.getOutputStreamAlreadyCalled();
            }
            this.responseState = ResponseState.WRITER;
            this.createOutputStream();
            ServletPrintWriter servletPrintWriter = new ServletPrintWriter(this.servletOutputStream, this.getCharacterEncoding());
            this.writer = ServletPrintWriterDelegate.newInstance(servletPrintWriter);
        }
        return this.writer;
    }

    private void createOutputStream() {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.bufferSize == null ? new ServletOutputStreamImpl(this.contentLength, (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)) : new ServletOutputStreamImpl(this.contentLength, (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY), this.bufferSize);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (this.insideInclude || this.responseStarted() || this.writer != null || this.isCommitted()) {
            return;
        }
        this.charsetSet = true;
        this.charset = charset;
        if (this.contentType != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
        }
    }

    public void setContentLength(int len) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(len));
        this.contentLength = len;
    }

    public void setContentLengthLong(long len) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(len));
        this.contentLength = len;
    }

    boolean isIgnoredFlushPerformed() {
        return this.ignoredFlushPerformed;
    }

    void setIgnoredFlushPerformed(boolean ignoredFlushPerformed) {
        this.ignoredFlushPerformed = ignoredFlushPerformed;
    }

    private boolean responseStarted() {
        return this.exchange.isResponseStarted() || this.ignoredFlushPerformed;
    }

    public void setContentType(String type) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        this.contentType = type;
        int split = type.indexOf(";");
        if (split != -1) {
            char c;
            int i;
            int pos = type.indexOf("charset=");
            if (pos != -1) {
                i = pos + "charset=".length();
                while ((c = type.charAt(i)) != ' ' && c != '\t' && c != ';' && ++i < type.length()) {
                }
                if (this.writer == null && !this.isCommitted()) {
                    this.charsetSet = true;
                    this.charset = type.substring(pos + "charset=".length(), i);
                    if (this.charset.startsWith("\"") && this.charset.endsWith("\"") && this.charset.length() > 1) {
                        this.charset = this.charset.substring(1, this.charset.length() - 1);
                    }
                }
                int charsetStart = pos;
                while (type.charAt(--charsetStart) != ';' && charsetStart > 0) {
                }
                StringBuilder contentTypeBuilder = new StringBuilder();
                contentTypeBuilder.append(type.substring(0, charsetStart));
                if (i != type.length()) {
                    contentTypeBuilder.append(type.substring(i));
                }
                this.contentType = contentTypeBuilder.toString();
            }
            for (i = this.contentType.length() - 1; i >= 0; --i) {
                c = this.contentType.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c != ';') break;
                this.contentType = this.contentType.substring(0, i);
                break;
            }
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
    }

    public void setBufferSize(int size) {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.setBufferSize(size);
        }
        this.bufferSize = size;
    }

    public int getBufferSize() {
        if (this.bufferSize == null) {
            return this.exchange.getConnection().getBufferSize();
        }
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        } else {
            this.createOutputStream();
            this.servletOutputStream.flush();
        }
    }

    public void closeStreamAndWriter() throws IOException {
        if (this.writer != null) {
            if (!this.servletOutputStream.isClosed()) {
                this.writer.flush();
            }
            this.writer.close();
        } else {
            if (this.servletOutputStream == null) {
                this.createOutputStream();
            }
            this.servletOutputStream.close();
        }
    }

    public void resetBuffer() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        if (this.writer != null) {
            this.writer = new PrintWriter((OutputStream)((Object)this.servletOutputStream), false);
        }
    }

    public boolean isCommitted() {
        return this.responseStarted();
    }

    public void reset() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.getResponseHeaders().clear();
        this.exchange.setResponseCode(200);
    }

    public void setLocale(Locale loc) {
        if (this.insideInclude || this.responseStarted()) {
            return;
        }
        this.locale = loc;
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, loc.getLanguage() + "-" + loc.getCountry());
        if (!this.charsetSet && this.writer == null) {
            Map<String, String> localeCharsetMapping = this.servletContext.getDeployment().getDeploymentInfo().getLocaleCharsetMapping();
            String charset = localeCharsetMapping.get(this.locale.toString());
            if (charset == null && (charset = localeCharsetMapping.get(this.locale.getLanguage() + "_" + this.locale.getCountry())) == null) {
                charset = localeCharsetMapping.get(this.locale.getLanguage());
            }
            if (charset != null) {
                this.charset = charset;
                if (this.contentType != null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
                }
            }
        }
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void responseDone() {
        if (this.responseDone) {
            return;
        }
        this.servletContext.updateSessionAccessTime(this.exchange);
        this.responseDone = true;
        try {
            this.closeStreamAndWriter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInsideInclude() {
        return this.insideInclude;
    }

    public void setInsideInclude(boolean insideInclude) {
        this.insideInclude = insideInclude;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.servletContext.getSession(this.originalServletContext.getSessionConfig(), this.exchange, true).getId());
        }
        return url;
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.servletContext.getSession(this.originalServletContext.getSessionConfig(), this.exchange, true).getId());
        }
        return url;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !this.hasScheme(location)) {
            return RedirectBuilder.redirect((HttpServerExchange)this.exchange, (String)location, (boolean)false);
        }
        return location;
    }

    private boolean hasScheme(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') continue;
            return false;
        }
        return false;
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpServletRequestImpl hreq = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getOriginalRequest();
        if (!this.originalServletContext.getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL)) {
            return false;
        }
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable(hreq, session, location);
    }

    private boolean doIsEncodeable(HttpServletRequestImpl hreq, HttpSession session, String location) {
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String file = url.getFile();
        if (file == null) {
            return false;
        }
        String tok = this.originalServletContext.getSessionCookieConfig().getName() + "=" + session.getId();
        return file.indexOf(tok) < 0;
    }

    protected String toEncoded(String url, String sessionId) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(';');
            sb.append(this.originalServletContext.getSessionCookieConfig().getName().toLowerCase(Locale.ENGLISH));
            sb.append('=');
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public static enum ResponseState {
        NONE,
        STREAM,
        WRITER;

    }
}

