/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ServletUpgradeListener;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.PartImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletInputStreamImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.LocaleUtils;
import io.undertow.util.Methods;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.xnio.LocalSocketAddress;

public final class HttpServletRequestImpl
implements HttpServletRequest {
    private static final String HTTPS = "https";
    private final HttpServerExchange exchange;
    private final ServletContextImpl originalServletContext;
    private ServletContextImpl servletContext;
    private Map<String, Object> attributes = null;
    private ServletInputStream servletInputStream;
    private BufferedReader reader;
    private Cookie[] cookies;
    private List<Part> parts = null;
    private volatile boolean asyncStarted = false;
    private volatile AsyncContextImpl asyncContext = null;
    private Map<String, Deque<String>> queryParameters;
    private FormData parsedFormData;
    private Charset characterEncoding;
    private boolean readStarted;
    private SessionConfig.SessionCookieSource sessionCookieSource;

    public HttpServletRequestImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
        this.originalServletContext = servletContext;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public String getAuthType() {
        SecurityContext securityContext = this.exchange.getSecurityContext();
        return securityContext != null ? securityContext.getMechanismName() : null;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Map cookies = this.exchange.getRequestCookies();
            if (cookies.isEmpty()) {
                return null;
            }
            Cookie[] value = new Cookie[cookies.size()];
            int i = 0;
            for (Map.Entry entry : cookies.entrySet()) {
                io.undertow.server.handlers.Cookie cookie = (io.undertow.server.handlers.Cookie)entry.getValue();
                Cookie c = new Cookie(cookie.getName(), cookie.getValue());
                if (cookie.getDomain() != null) {
                    c.setDomain(cookie.getDomain());
                }
                c.setHttpOnly(cookie.isHttpOnly());
                if (cookie.getMaxAge() != null) {
                    c.setMaxAge(cookie.getMaxAge().intValue());
                }
                if (cookie.getPath() != null) {
                    c.setPath(cookie.getPath());
                }
                c.setSecure(cookie.isSecure());
                c.setVersion(cookie.getVersion());
                value[i++] = c;
            }
            this.cookies = value;
        }
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.exchange.getRequestHeaders().getFirst(name);
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)header);
        if (date == null) {
            throw UndertowServletMessages.MESSAGES.headerCannotBeConvertedToDate(header);
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        return headers.getFirst(name);
    }

    public String getHeader(HttpString name) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        return headers.getFirst(name);
    }

    public Enumeration<String> getHeaders(String name) {
        HeaderValues headers = this.exchange.getRequestHeaders().get(name);
        if (headers == null) {
            return EmptyEnumeration.instance();
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getRequestHeaders().getHeaderNames()) {
            headers.add(i.toString());
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public String getMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    public String getPathInfo() {
        ServletPathMatch match = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletPathMatch();
        if (match != null) {
            return match.getRemaining();
        }
        return null;
    }

    public String getPathTranslated() {
        return this.getRealPath(this.getPathInfo());
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getQueryString() {
        return this.exchange.getQueryString().isEmpty() ? null : this.exchange.getQueryString();
    }

    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    public boolean isUserInRole(String role) {
        Set<String> roles;
        if (role == null) {
            return false;
        }
        if (role.equals("*")) {
            return false;
        }
        SecurityContext sc = this.exchange.getSecurityContext();
        Account account = sc.getAuthenticatedAccount();
        if (account == null) {
            return false;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (role.equals("**") && !(roles = servletRequestContext.getDeployment().getDeploymentInfo().getSecurityRoles()).contains("**")) {
            return true;
        }
        ServletChain servlet = servletRequestContext.getCurrentServlet();
        Deployment deployment = this.servletContext.getDeployment();
        AuthorizationManager authorizationManager = deployment.getDeploymentInfo().getAuthorizationManager();
        return authorizationManager.isUserInRole(role, account, servlet.getManagedServlet().getServletInfo(), this, deployment);
    }

    public Principal getUserPrincipal() {
        SecurityContext securityContext = this.exchange.getSecurityContext();
        Principal result = null;
        Account account = null;
        if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) != null) {
            result = account.getPrincipal();
        }
        return result;
    }

    public String getRequestedSessionId() {
        SessionConfig config = this.originalServletContext.getSessionConfig();
        return config.findSessionId(this.exchange);
    }

    public String changeSessionId() {
        HttpSessionImpl session = this.servletContext.getSession(this.originalServletContext, this.exchange, false);
        if (session == null) {
            throw UndertowServletMessages.MESSAGES.noSession();
        }
        String oldId = session.getId();
        Session underlyingSession = System.getSecurityManager() == null ? session.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session));
        String newId = underlyingSession.changeSessionId(this.exchange, this.originalServletContext.getSessionConfig());
        this.servletContext.getDeployment().getApplicationListeners().httpSessionIdChanged(session, oldId);
        return newId;
    }

    public String getRequestURI() {
        if (this.exchange.isHostIncludedInRequestURI()) {
            String uri = this.exchange.getRequestURI();
            int slashes = 0;
            for (int i = 0; i < uri.length(); ++i) {
                if (uri.charAt(i) != '/' || ++slashes != 3) continue;
                return uri.substring(i);
            }
            return "/";
        }
        return this.exchange.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.exchange.getRequestURL());
    }

    public String getServletPath() {
        ServletPathMatch match = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletPathMatch();
        if (match != null) {
            return match.getMatched();
        }
        return "";
    }

    public HttpSession getSession(boolean create) {
        return this.servletContext.getSession(this.originalServletContext, this.exchange, create);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        HttpSessionImpl session = this.servletContext.getSession(this.originalServletContext, this.exchange, false);
        return session != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.sessionCookieSource() == SessionConfig.SessionCookieSource.COOKIE;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.sessionCookieSource() == SessionConfig.SessionCookieSource.URL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        SecurityContext sc = this.exchange.getSecurityContext();
        sc.setAuthenticationRequired();
        if (sc.authenticate()) {
            if (sc.isAuthenticated()) {
                return true;
            }
            throw UndertowServletMessages.MESSAGES.authenticationFailed();
        }
        HttpServletResponseImpl responseImpl = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getOriginalResponse();
        responseImpl.closeStreamAndWriter();
        return false;
    }

    public void login(String username, String password) throws ServletException {
        if (username == null || password == null) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
        SecurityContext sc = this.exchange.getSecurityContext();
        if (sc.isAuthenticated()) {
            throw UndertowServletMessages.MESSAGES.userAlreadyLoggedIn();
        }
        boolean login = false;
        try {
            login = sc.login(username, password);
        }
        catch (SecurityException se) {
            if (se.getCause() instanceof ServletException) {
                throw (ServletException)se.getCause();
            }
            throw new ServletException((Throwable)se);
        }
        if (!login) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
    }

    public void logout() throws ServletException {
        HttpSession session;
        SecurityContext sc = this.exchange.getSecurityContext();
        sc.logout();
        if (this.servletContext.getDeployment().getDeploymentInfo().isInvalidateSessionOnLogout() && (session = this.getSession(false)) != null) {
            session.invalidate();
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        return this.parts;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        for (Part part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException {
        try {
            InstanceFactory<T> factory = this.servletContext.getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(handlerClass);
            InstanceHandle<T> instance = factory.createInstance();
            this.exchange.upgradeChannel(new ServletUpgradeListener<T>(instance, this.servletContext.getDeployment().getThreadSetupAction(), this.exchange));
            return (T)((HttpUpgradeHandler)instance.getInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadParts() throws IOException, ServletException {
        ServletRequestContext requestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (this.parts == null) {
            ArrayList<Part> parts = new ArrayList<Part>();
            String mimeType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (mimeType != null && mimeType.startsWith("multipart/form-data")) {
                FormData formData = this.parseFormData();
                if (formData != null) {
                    for (String namedPart : formData) {
                        for (FormData.FormValue part : formData.get(namedPart)) {
                            parts.add(new PartImpl(namedPart, part, requestContext.getOriginalServletPathMatch().getServletChain().getManagedServlet().getServletInfo().getMultipartConfig(), this.servletContext));
                        }
                    }
                }
            } else {
                throw UndertowServletMessages.MESSAGES.notAMultiPartRequest();
            }
            this.parts = parts;
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return EmptyEnumeration.instance();
        }
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding.name();
        }
        String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        return Headers.extractQuotedValueFromHeader((String)contentType, (String)"charset");
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.readStarted) {
            return;
        }
        try {
            this.characterEncoding = Charset.forName(env);
            ManagedServlet originalServlet = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getOriginalServletPathMatch().getServletChain().getManagedServlet();
            FormDataParser parser = originalServlet.getFormParserFactory().createParser(this.exchange);
            if (parser != null) {
                parser.setCharacterEncoding(env);
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException();
        }
    }

    public int getContentLength() {
        long length = this.getContentLengthLong();
        if (length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)length;
    }

    public long getContentLengthLong() {
        String contentLength = this.getHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    public String getContentType() {
        return this.getHeader(Headers.CONTENT_TYPE);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw UndertowServletMessages.MESSAGES.getReaderAlreadyCalled();
        }
        if (this.servletInputStream == null) {
            this.servletInputStream = new ServletInputStreamImpl(this);
        }
        this.readStarted = true;
        return this.servletInputStream;
    }

    public void closeAndDrainRequest() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.servletInputStream == null) {
            this.servletInputStream = new ServletInputStreamImpl(this);
        }
        this.servletInputStream.close();
    }

    public String getParameter(String name) {
        Deque<String> params;
        if (this.queryParameters == null) {
            this.queryParameters = this.exchange.getQueryParameters();
        }
        if ((params = this.queryParameters.get(name)) == null) {
            FormData parsedFormData;
            if (this.exchange.getRequestMethod().equals(Methods.POST) && (parsedFormData = this.parseFormData()) != null) {
                FormData.FormValue res = parsedFormData.getFirst(name);
                if (res == null || res.isFile()) {
                    return null;
                }
                return res.getValue();
            }
            return null;
        }
        return params.getFirst();
    }

    public Enumeration<String> getParameterNames() {
        FormData parsedFormData;
        if (this.queryParameters == null) {
            this.queryParameters = this.exchange.getQueryParameters();
        }
        HashSet<String> parameterNames = new HashSet<String>(this.queryParameters.keySet());
        if (this.exchange.getRequestMethod().equals(Methods.POST) && (parsedFormData = this.parseFormData()) != null) {
            block0: for (String name : parsedFormData) {
                for (FormData.FormValue param : parsedFormData.get(name)) {
                    if (param.isFile()) continue;
                    parameterNames.add(name);
                    continue block0;
                }
            }
        }
        return new IteratorEnumeration<String>(parameterNames.iterator());
    }

    public String[] getParameterValues(String name) {
        Deque res;
        FormData parsedFormData;
        if (this.queryParameters == null) {
            this.queryParameters = this.exchange.getQueryParameters();
        }
        ArrayList<String> ret = new ArrayList<String>();
        Deque<String> params = this.queryParameters.get(name);
        if (params != null) {
            for (String param : params) {
                ret.add(param);
            }
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST) && (parsedFormData = this.parseFormData()) != null && (res = parsedFormData.get(name)) != null) {
            for (FormData.FormValue value : res) {
                if (value.isFile()) continue;
                ret.add(value.getValue());
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Map<String, String[]> getParameterMap() {
        FormData parsedFormData;
        if (this.queryParameters == null) {
            this.queryParameters = this.exchange.getQueryParameters();
        }
        HashMap arrayMap = new HashMap();
        for (Map.Entry<String, Deque<String>> entry : this.queryParameters.entrySet()) {
            arrayMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST) && (parsedFormData = this.parseFormData()) != null) {
            for (String name : parsedFormData) {
                Deque val = parsedFormData.get(name);
                if (arrayMap.containsKey(name)) {
                    ArrayList existing = (ArrayList)arrayMap.get(name);
                    for (FormData.FormValue v : val) {
                        if (v.isFile()) continue;
                        existing.add(v.getValue());
                    }
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                boolean i = false;
                for (FormData.FormValue v : val) {
                    if (v.isFile()) continue;
                    values.add(v.getValue());
                }
                arrayMap.put(name, values);
            }
        }
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        for (Map.Entry entry : arrayMap.entrySet()) {
            ret.put((String)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[((ArrayList)entry.getValue()).size()]));
        }
        return ret;
    }

    private FormData parseFormData() {
        if (this.parsedFormData == null) {
            if (this.readStarted) {
                return null;
            }
            ManagedServlet originalServlet = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet().getManagedServlet();
            FormDataParser parser = originalServlet.getFormParserFactory().createParser(this.exchange);
            if (parser == null) {
                return null;
            }
            this.readStarted = true;
            try {
                this.parsedFormData = parser.parseBlocking();
                return this.parsedFormData;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.parsedFormData;
    }

    public String getProtocol() {
        return this.exchange.getProtocol().toString();
    }

    public String getScheme() {
        return this.exchange.getRequestScheme();
    }

    public String getServerName() {
        return this.exchange.getHostName();
    }

    public int getServerPort() {
        return this.exchange.getHostPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            if (this.servletInputStream != null) {
                throw UndertowServletMessages.MESSAGES.getInputStreamAlreadyCalled();
            }
            Charset charSet = this.servletContext.getDeployment().getDefaultCharset();
            if (this.characterEncoding != null) {
                charSet = this.characterEncoding;
            } else {
                String c;
                String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                if (contentType != null && (c = Headers.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                    try {
                        charSet = Charset.forName(c);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new UnsupportedEncodingException();
                    }
                }
            }
            this.reader = new BufferedReader(new InputStreamReader(this.exchange.getInputStream(), charSet));
        }
        this.readStarted = true;
        return this.reader;
    }

    public String getRemoteAddr() {
        InetSocketAddress sourceAddress = this.exchange.getSourceAddress();
        if (sourceAddress == null) {
            return "";
        }
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            return sourceAddress.getHostString();
        }
        return address.getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress sourceAddress = this.exchange.getSourceAddress();
        if (sourceAddress == null) {
            return "";
        }
        return sourceAddress.getHostString();
    }

    public void setAttribute(String name, Object object) {
        Object existing;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if ((existing = this.attributes.put(name, object)) != null) {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeReplaced(this, name, existing);
        } else {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeAdded(this, name, object);
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes == null) {
            return;
        }
        Object exiting = this.attributes.remove(name);
        this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeRemoved(this, name, exiting);
    }

    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public Enumeration<Locale> getLocales() {
        HeaderValues acceptLanguage = this.exchange.getRequestHeaders().get(Headers.ACCEPT_LANGUAGE);
        List ret = LocaleUtils.getLocalesFromHeader((List)acceptLanguage);
        return new IteratorEnumeration<Locale>(ret.iterator());
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase(HTTPS);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String realPath;
        if (path.startsWith("/")) {
            realPath = path;
        } else {
            String current = this.exchange.getRelativePath();
            int lastSlash = current.lastIndexOf("/");
            if (lastSlash != -1) {
                current = current.substring(0, lastSlash + 1);
            }
            realPath = CanonicalPathUtils.canonicalize((String)(current + path));
        }
        return new RequestDispatcherImpl(realPath, this.servletContext);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public int getRemotePort() {
        return this.exchange.getSourceAddress().getPort();
    }

    public String getLocalName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    public String getLocalAddr() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress().getHostAddress();
        }
        if (address instanceof LocalSocketAddress) {
            return ((LocalSocketAddress)address).getName();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncStarted) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.asyncStarted = true;
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        this.asyncContext = new AsyncContextImpl(this.exchange, servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse(), servletRequestContext, false, this.asyncContext);
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != servletRequest && !(servletRequest instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(servletRequest);
            }
            if (servletRequestContext.getOriginalResponse() != servletResponse && !(servletResponse instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(servletResponse);
            }
        }
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncStarted) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.asyncStarted = true;
        this.asyncContext = new AsyncContextImpl(this.exchange, servletRequest, servletResponse, servletRequestContext, true, this.asyncContext);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public boolean isAsyncSupported() {
        Boolean supported = (Boolean)this.exchange.getAttachment(AsyncContextImpl.ASYNC_SUPPORTED);
        return supported == null || supported != false;
    }

    public AsyncContextImpl getAsyncContext() {
        if (!this.asyncStarted) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        return this.asyncContext;
    }

    public AsyncContextImpl getAsyncContextInternal() {
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        return ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getDispatcherType();
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = this.exchange.getQueryParameters();
        }
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Deque<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    void asyncRequestDispatched() {
        this.asyncStarted = false;
    }

    public String getOriginalRequestURI() {
        String uri = (String)this.getAttribute("javax.servlet.forward.request_uri");
        if (uri != null) {
            return uri;
        }
        uri = (String)this.getAttribute("javax.servlet.async.request_uri");
        if (uri != null) {
            return uri;
        }
        return this.getRequestURI();
    }

    public String getOriginalServletPath() {
        String uri = (String)this.getAttribute("javax.servlet.forward.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = (String)this.getAttribute("javax.servlet.async.servlet_path");
        if (uri != null) {
            return uri;
        }
        return this.getServletPath();
    }

    public String getOriginalPathInfo() {
        String uri = (String)this.getAttribute("javax.servlet.forward.path_info");
        if (uri != null) {
            return uri;
        }
        uri = (String)this.getAttribute("javax.servlet.async.path_info");
        if (uri != null) {
            return uri;
        }
        return this.getPathInfo();
    }

    public String getOriginalContextPath() {
        String uri = (String)this.getAttribute("javax.servlet.forward.context_path");
        if (uri != null) {
            return uri;
        }
        uri = (String)this.getAttribute("javax.servlet.async.context_path");
        if (uri != null) {
            return uri;
        }
        return this.getContextPath();
    }

    public String getOriginalQueryString() {
        String uri = (String)this.getAttribute("javax.servlet.forward.query_string");
        if (uri != null) {
            return uri;
        }
        uri = (String)this.getAttribute("javax.servlet.async.query_string");
        if (uri != null) {
            return uri;
        }
        return this.getQueryString();
    }

    private SessionConfig.SessionCookieSource sessionCookieSource() {
        if (this.sessionCookieSource == null) {
            this.sessionCookieSource = this.originalServletContext.getSessionConfig().sessionCookieSource(this.exchange);
        }
        return this.sessionCookieSource;
    }
}

