/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.ServletContextImpl;

public class SessionCookieConfigImpl
implements javax.servlet.SessionCookieConfig,
SessionConfig {
    private final ServletContextImpl servletContext;
    private final SessionCookieConfig delegate;
    private SessionConfig fallback;

    public SessionCookieConfigImpl(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
        this.delegate = new SessionCookieConfig();
    }

    public String rewriteUrl(String originalUrl, String sessionid) {
        return originalUrl;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        this.delegate.setSessionId(exchange, sessionId);
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        this.delegate.clearSession(exchange, sessionId);
    }

    public String findSessionId(HttpServerExchange exchange) {
        String existing = this.delegate.findSessionId(exchange);
        if (existing != null) {
            return existing;
        }
        if (this.fallback != null) {
            return this.fallback.findSessionId(exchange);
        }
        return null;
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        String existing = this.delegate.findSessionId(exchange);
        if (existing != null) {
            return SessionConfig.SessionCookieSource.COOKIE;
        }
        if (this.fallback != null) {
            String id = this.fallback.findSessionId(exchange);
            return id != null ? this.fallback.sessionCookieSource(exchange) : SessionConfig.SessionCookieSource.NONE;
        }
        return SessionConfig.SessionCookieSource.NONE;
    }

    public String getName() {
        return this.delegate.getCookieName();
    }

    public void setName(String name) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setCookieName(name);
    }

    public String getDomain() {
        return this.delegate.getDomain();
    }

    public void setDomain(String domain) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setDomain(domain);
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public void setPath(String path) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setPath(path);
    }

    public String getComment() {
        return this.delegate.getComment();
    }

    public void setComment(String comment) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setComment(comment);
    }

    public boolean isHttpOnly() {
        return this.delegate.isHttpOnly();
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setHttpOnly(httpOnly);
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public void setSecure(boolean secure) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setSecure(secure);
    }

    public int getMaxAge() {
        return this.delegate.getMaxAge();
    }

    public void setMaxAge(int maxAge) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setMaxAge(maxAge);
    }

    public SessionConfig getFallback() {
        return this.fallback;
    }

    public void setFallback(SessionConfig fallback) {
        this.fallback = fallback;
    }
}

