/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.ExceptionLog;
import io.undertow.servlet.api.ExceptionHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.logging.Logger;

public class LoggingExceptionHandler
implements ExceptionHandler {
    public static LoggingExceptionHandler DEFAULT = new LoggingExceptionHandler(Collections.emptyMap());
    private final Map<Class<? extends Throwable>, ExceptionDetails> exceptionDetails;

    public LoggingExceptionHandler(Map<Class<? extends Throwable>, ExceptionDetails> exceptionDetails) {
        this.exceptionDetails = exceptionDetails;
    }

    @Override
    public boolean handleThrowable(HttpServerExchange exchange, ServletRequest request, ServletResponse response, Throwable t) {
        ExceptionDetails details = null;
        if (!this.exceptionDetails.isEmpty()) {
            for (Class<?> c = t.getClass(); c != null && c != Object.class && (details = this.exceptionDetails.get(c)) == null; c = c.getSuperclass()) {
            }
        }
        ExceptionLog log = t.getClass().getAnnotation(ExceptionLog.class);
        if (details != null) {
            Logger.Level level = details.level;
            Logger.Level stackTraceLevel = details.stackTraceLevel;
            String category = details.category;
            this.handleCustomLog(exchange, t, level, stackTraceLevel, category);
        } else if (log != null) {
            Logger.Level level = log.value();
            Logger.Level stackTraceLevel = log.stackTraceLevel();
            String category = log.category();
            this.handleCustomLog(exchange, t, level, stackTraceLevel, category);
        } else if (t instanceof IOException) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf(t, "Exception handling request to %s", (Object)exchange.getRequestURI());
        } else {
            UndertowLogger.REQUEST_LOGGER.exceptionHandlingRequest(t, exchange.getRequestURI());
        }
        return false;
    }

    private void handleCustomLog(HttpServerExchange exchange, Throwable t, Logger.Level level, Logger.Level stackTraceLevel, String category) {
        UndertowLogger logger2 = UndertowLogger.REQUEST_LOGGER;
        if (!category.isEmpty()) {
            logger2 = Logger.getLogger((String)category);
        }
        boolean stackTrace = true;
        if (stackTraceLevel.ordinal() > level.ordinal() && !logger2.isEnabled(stackTraceLevel)) {
            stackTrace = false;
        }
        if (stackTrace) {
            logger2.logf(level, t, "Exception handling request to %s", (Object)exchange.getRequestURI());
        } else {
            logger2.logf(level, "Exception handling request to %s: %s", (Object)exchange.getRequestURI(), (Object)t.getMessage());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Class<? extends Throwable>, ExceptionDetails> exceptionDetails = new HashMap<Class<? extends Throwable>, ExceptionDetails>();

        Builder() {
        }

        public Builder add(Class<? extends Throwable> exception, String category, Logger.Level level) {
            this.exceptionDetails.put(exception, new ExceptionDetails(level, Logger.Level.FATAL, category));
            return this;
        }

        public Builder add(Class<? extends Throwable> exception, String category) {
            this.exceptionDetails.put(exception, new ExceptionDetails(Logger.Level.ERROR, Logger.Level.FATAL, category));
            return this;
        }

        public Builder add(Class<? extends Throwable> exception, String category, Logger.Level level, Logger.Level stackTraceLevel) {
            this.exceptionDetails.put(exception, new ExceptionDetails(level, stackTraceLevel, category));
            return this;
        }

        public LoggingExceptionHandler build() {
            return new LoggingExceptionHandler(this.exceptionDetails);
        }
    }

    private static class ExceptionDetails {
        final Logger.Level level;
        final Logger.Level stackTraceLevel;
        final String category;

        private ExceptionDetails(Logger.Level level, Logger.Level stackTraceLevel, String category) {
            this.level = level;
            this.stackTraceLevel = stackTraceLevel;
            this.category = category;
        }
    }
}

