/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.LifecyleInterceptorInvocation;
import io.undertow.servlet.spec.ServletConfigImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;

public class ManagedServlet
implements Lifecycle {
    private final ServletInfo servletInfo;
    private final ServletContextImpl servletContext;
    private volatile boolean started = false;
    private final InstanceStrategy instanceStrategy;
    private volatile boolean permanentlyUnavailable = false;
    private long maxRequestSize;
    private FormParserFactory formParserFactory;
    private MultipartConfigElement multipartConfig;

    public ManagedServlet(ServletInfo servletInfo, ServletContextImpl servletContext) {
        this.servletInfo = servletInfo;
        this.servletContext = servletContext;
        this.instanceStrategy = SingleThreadModel.class.isAssignableFrom(servletInfo.getServletClass()) ? new SingleThreadModelPoolStrategy(servletInfo.getInstanceFactory(), servletInfo, servletContext) : new DefaultInstanceStrategy(servletInfo.getInstanceFactory(), servletInfo, servletContext);
        this.setupMultipart(servletContext);
    }

    public void setupMultipart(ServletContextImpl servletContext) {
        FormEncodedDataDefinition formDataParser = new FormEncodedDataDefinition().setDefaultEncoding(servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding());
        MultipartConfigElement multipartConfig = this.servletInfo.getMultipartConfig();
        if (multipartConfig == null) {
            multipartConfig = servletContext.getDeployment().getDeploymentInfo().getDefaultMultipartConfig();
        }
        this.multipartConfig = multipartConfig;
        if (multipartConfig != null) {
            String location;
            Path locFile;
            MultipartConfigElement config = multipartConfig;
            this.maxRequestSize = config.getMaxRequestSize() != -1L ? config.getMaxRequestSize() : -1L;
            Path tempDir = config.getLocation() == null || config.getLocation().isEmpty() ? servletContext.getDeployment().getDeploymentInfo().getTempPath() : ((locFile = Paths.get(location = config.getLocation(), new String[0])).isAbsolute() ? locFile : servletContext.getDeployment().getDeploymentInfo().getTempPath().resolve(location));
            MultiPartParserDefinition multiPartParserDefinition = new MultiPartParserDefinition(tempDir);
            if (config.getMaxFileSize() > 0L) {
                multiPartParserDefinition.setMaxIndividualFileSize(config.getMaxFileSize());
            }
            multiPartParserDefinition.setDefaultEncoding(servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding());
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).addParser((FormParserFactory.ParserDefinition)multiPartParserDefinition).build();
        } else {
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).build();
            this.maxRequestSize = -1L;
        }
    }

    @Override
    public synchronized void start() throws ServletException {
    }

    public void createServlet() throws ServletException {
        block4: {
            if (this.permanentlyUnavailable) {
                return;
            }
            try {
                if (!this.started && this.servletInfo.getLoadOnStartup() != null && this.servletInfo.getLoadOnStartup() >= 0) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
            catch (UnavailableException e) {
                if (!e.isPermanent()) break block4;
                this.permanentlyUnavailable = true;
                this.stop();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.instanceStrategy.stop();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isPermanentlyUnavailable() {
        return this.permanentlyUnavailable;
    }

    public void setPermanentlyUnavailable(boolean permanentlyUnavailable) {
        this.permanentlyUnavailable = permanentlyUnavailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceHandle<? extends Servlet> getServlet() throws ServletException {
        if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
            throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
        }
        if (!this.started) {
            ManagedServlet managedServlet = this;
            synchronized (managedServlet) {
                if (!this.started) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
        }
        return this.instanceStrategy.getServlet();
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public FormParserFactory getFormParserFactory() {
        return this.formParserFactory;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    private static class SingleThreadModelPoolStrategy
    implements InstanceStrategy {
        private final InstanceFactory<? extends Servlet> factory;
        private final ServletInfo servletInfo;
        private final ServletContextImpl servletContext;

        private SingleThreadModelPoolStrategy(InstanceFactory<? extends Servlet> factory, ServletInfo servletInfo, ServletContextImpl servletContext) {
            this.factory = factory;
            this.servletInfo = servletInfo;
            this.servletContext = servletContext;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public InstanceHandle<? extends Servlet> getServlet() throws ServletException {
            InstanceHandle<? extends Servlet> instanceHandle;
            try {
                instanceHandle = this.factory.createInstance();
            }
            catch (Exception e) {
                throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.servletInfo.getName(), e);
            }
            final Servlet instance = instanceHandle.getInstance();
            new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.servletInfo, instance, new ServletConfigImpl(this.servletInfo, this.servletContext)).proceed();
            return new InstanceHandle<Servlet>(){

                @Override
                public Servlet getInstance() {
                    return instance;
                }

                @Override
                public void release() {
                    instance.destroy();
                    instanceHandle.release();
                }
            };
        }
    }

    private static class DefaultInstanceStrategy
    implements InstanceStrategy {
        private final InstanceFactory<? extends Servlet> factory;
        private final ServletInfo servletInfo;
        private final ServletContextImpl servletContext;
        private volatile InstanceHandle<? extends Servlet> handle;
        private volatile Servlet instance;
        private ResourceChangeListener changeListener;

        DefaultInstanceStrategy(InstanceFactory<? extends Servlet> factory, ServletInfo servletInfo, ServletContextImpl servletContext) {
            this.factory = factory;
            this.servletInfo = servletInfo;
            this.servletContext = servletContext;
        }

        @Override
        public synchronized void start() throws ServletException {
            try {
                this.handle = this.factory.createInstance();
            }
            catch (Exception e) {
                throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.servletInfo.getName(), e);
            }
            this.instance = this.handle.getInstance();
            new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.servletInfo, this.instance, new ServletConfigImpl(this.servletInfo, this.servletContext)).proceed();
            ResourceManager resourceManager = this.servletContext.getDeployment().getDeploymentInfo().getResourceManager();
            if (this.instance instanceof ResourceChangeListener && resourceManager.isResourceChangeListenerSupported()) {
                this.changeListener = (ResourceChangeListener)this.instance;
                resourceManager.registerResourceChangeListener(this.changeListener);
            }
        }

        @Override
        public synchronized void stop() {
            if (this.handle != null) {
                ResourceManager resourceManager = this.servletContext.getDeployment().getDeploymentInfo().getResourceManager();
                if (this.changeListener != null) {
                    resourceManager.removeResourceChangeListener(this.changeListener);
                }
                this.invokeDestroy();
                this.handle.release();
            }
        }

        private void invokeDestroy() {
            List<LifecycleInterceptor> interceptors = this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors();
            try {
                new LifecyleInterceptorInvocation(interceptors, this.servletInfo, this.instance).proceed();
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InstanceHandle<? extends Servlet> getServlet() {
            return new InstanceHandle<Servlet>(){

                @Override
                public Servlet getInstance() {
                    return instance;
                }

                @Override
                public void release() {
                }
            };
        }
    }

    static interface InstanceStrategy {
        public void start() throws ServletException;

        public void stop();

        public InstanceHandle<? extends Servlet> getServlet() throws ServletException;
    }
}

