package io.undertow.servlet;

import java.io.Serializable;
import java.net.MalformedURLException;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.servlet.UnavailableException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Date;
import java.lang.Exception;
import javax.servlet.ServletException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-11-05T10:02:39+1100")
public class UndertowServletLogger_$logger extends DelegatingBasicLogger implements UndertowServletLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowServletLogger_$logger.class.getName();
    public UndertowServletLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void ioExceptionHandingRequest(final IOException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, ioExceptionHandingRequest$str());
    }
    private static final String ioExceptionHandingRequest = "UT015000: IOException handling request";
    protected String ioExceptionHandingRequest$str() {
        return ioExceptionHandingRequest;
    }
    @Override
    public final void servletExceptionHandlingRequest(final ServletException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, servletExceptionHandlingRequest$str());
    }
    private static final String servletExceptionHandlingRequest = "UT015001: ServletException handling request";
    protected String servletExceptionHandlingRequest$str() {
        return servletExceptionHandlingRequest;
    }
    @Override
    public final void stoppingServletDueToPermanentUnavailability(final String servlet, final UnavailableException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, stoppingServletDueToPermanentUnavailability$str(), servlet);
    }
    private static final String stoppingServletDueToPermanentUnavailability = "UT015002: Stopping servlet %s due to permanent unavailability";
    protected String stoppingServletDueToPermanentUnavailability$str() {
        return stoppingServletDueToPermanentUnavailability;
    }
    @Override
    public final void stoppingServletUntilDueToTemporaryUnavailability(final String name, final Date till, final UnavailableException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, stoppingServletUntilDueToTemporaryUnavailability$str(), name, till);
    }
    private static final String stoppingServletUntilDueToTemporaryUnavailability = "UT015003: Stopping servlet %s till %s due to temporary unavailability";
    protected String stoppingServletUntilDueToTemporaryUnavailability$str() {
        return stoppingServletUntilDueToTemporaryUnavailability;
    }
    @Override
    public final void malformedUrlException(final String relativePath, final MalformedURLException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, malformedUrlException$str(), relativePath);
    }
    private static final String malformedUrlException = "UT015004: Malformed URL exception reading resource %s";
    protected String malformedUrlException$str() {
        return malformedUrlException;
    }
    @Override
    public final void errorInvokingListener(final String method, final Class<? extends Object> listenerClass, final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, errorInvokingListener$str(), method, listenerClass);
    }
    private static final String errorInvokingListener = "UT015005: Error invoking method %s on listener %s";
    protected String errorInvokingListener$str() {
        return errorInvokingListener;
    }
    @Override
    public final void ioExceptionDispatchingAsyncEvent(final IOException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, ioExceptionDispatchingAsyncEvent$str());
    }
    private static final String ioExceptionDispatchingAsyncEvent = "UT015006: IOException dispatching async event";
    protected String ioExceptionDispatchingAsyncEvent$str() {
        return ioExceptionDispatchingAsyncEvent;
    }
    @Override
    public final void servletStackTracesAll(final String deploymentName) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, servletStackTracesAll$str(), deploymentName);
    }
    private static final String servletStackTracesAll = "UT015007: Stack trace on error enabled for deployment %s, please do not enable for production use";
    protected String servletStackTracesAll$str() {
        return servletStackTracesAll;
    }
    @Override
    public final void failedtoLoadPersistentSessions(final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, failedtoLoadPersistentSessions$str());
    }
    private static final String failedtoLoadPersistentSessions = "UT015008: Failed to load development mode persistent sessions";
    protected String failedtoLoadPersistentSessions$str() {
        return failedtoLoadPersistentSessions;
    }
    @Override
    public final void failedToPersistSessionAttribute(final String attributeName, final Object value, final String sessionID, final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, failedToPersistSessionAttribute$str(), attributeName, value, sessionID);
    }
    private static final String failedToPersistSessionAttribute = "UT015009: Failed to persist session attribute %s with value %s for session %s";
    protected String failedToPersistSessionAttribute$str() {
        return failedToPersistSessionAttribute;
    }
    @Override
    public final void failedToPersistSessions(final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, failedToPersistSessions$str());
    }
    private static final String failedToPersistSessions = "UT015010: Failed to persist sessions";
    protected String failedToPersistSessions$str() {
        return failedToPersistSessions;
    }
    @Override
    public final void nonStandardFilterMapping(final String filterName) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, nonStandardFilterMapping$str(), filterName);
    }
    private static final String nonStandardFilterMapping = "UT015011: Non standard filter mapping '*' for filter %s. Portable application should use '/*' instead.";
    protected String nonStandardFilterMapping$str() {
        return nonStandardFilterMapping;
    }
    @Override
    public final void errorGeneratingErrorPage(final String originalErrorPage, final Object originalException, final int code, final Throwable cause) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorGeneratingErrorPage$str(), originalErrorPage, originalException, code);
    }
    private static final String errorGeneratingErrorPage = "UT015012: Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.";
    protected String errorGeneratingErrorPage$str() {
        return errorGeneratingErrorPage;
    }
    private static final String errorOpeningRewriteConfiguration = "UT015013: Error opening rewrite configuration";
    protected String errorOpeningRewriteConfiguration$str() {
        return errorOpeningRewriteConfiguration;
    }
    @Override
    public final String errorOpeningRewriteConfiguration() {
        return String.format(errorOpeningRewriteConfiguration$str());
    }
    @Override
    public final void errorReadingRewriteConfiguration(final IOException e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, errorReadingRewriteConfiguration$str());
    }
    private static final String errorReadingRewriteConfiguration = "UT015014: Error reading rewrite configuration";
    protected String errorReadingRewriteConfiguration$str() {
        return errorReadingRewriteConfiguration;
    }
    private static final String invalidRewriteConfiguration = "UT015015: Error reading rewrite configuration: %s";
    protected String invalidRewriteConfiguration$str() {
        return invalidRewriteConfiguration;
    }
    @Override
    public final IllegalArgumentException invalidRewriteConfiguration(final String line) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidRewriteConfiguration$str(), line));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRewriteMap = "UT015016: Invalid rewrite map class: %s";
    protected String invalidRewriteMap$str() {
        return invalidRewriteMap;
    }
    @Override
    public final IllegalArgumentException invalidRewriteMap(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidRewriteMap$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRewriteFlags2 = "UT015017: Error reading rewrite flags in line %s as %s";
    protected String invalidRewriteFlags2$str() {
        return invalidRewriteFlags2;
    }
    @Override
    public final IllegalArgumentException invalidRewriteFlags(final String line, final String flags) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidRewriteFlags2$str(), line, flags));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRewriteFlags1 = "UT015018: Error reading rewrite flags in line %s";
    protected String invalidRewriteFlags1$str() {
        return invalidRewriteFlags1;
    }
    @Override
    public final IllegalArgumentException invalidRewriteFlags(final String line) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidRewriteFlags1$str(), line));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToDestroy(final Object object, final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, failedToDestroy$str(), object);
    }
    private static final String failedToDestroy = "UT015019: Failed to destroy %s";
    protected String failedToDestroy$str() {
        return failedToDestroy;
    }
}
