package io.undertow.servlet;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import javax.servlet.UnavailableException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.util.Date;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-08-12T14:00:42-0300")
public class UndertowServletLogger_$logger extends DelegatingBasicLogger implements UndertowServletLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowServletLogger_$logger.class.getName();
    public UndertowServletLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void stoppingServletDueToPermanentUnavailability(final String servlet, final UnavailableException e) {
        super.log.logf(FQCN, ERROR, e, stoppingServletDueToPermanentUnavailability$str(), servlet);
    }
    protected String stoppingServletDueToPermanentUnavailability$str() {
        return "UT015002: Stopping servlet %s due to permanent unavailability";
    }
    @Override
    public final void stoppingServletUntilDueToTemporaryUnavailability(final String name, final Date till, final UnavailableException e) {
        super.log.logf(FQCN, ERROR, e, stoppingServletUntilDueToTemporaryUnavailability$str(), name, till);
    }
    protected String stoppingServletUntilDueToTemporaryUnavailability$str() {
        return "UT015003: Stopping servlet %s till %s due to temporary unavailability";
    }
    @Override
    public final void errorInvokingListener(final String method, final Class<?> listenerClass, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorInvokingListener$str(), method, listenerClass);
    }
    protected String errorInvokingListener$str() {
        return "UT015005: Error invoking method %s on listener %s";
    }
    @Override
    public final void ioExceptionDispatchingAsyncEvent(final IOException e) {
        super.log.logf(FQCN, ERROR, e, ioExceptionDispatchingAsyncEvent$str());
    }
    protected String ioExceptionDispatchingAsyncEvent$str() {
        return "UT015006: IOException dispatching async event";
    }
    @Override
    public final void servletStackTracesAll(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, servletStackTracesAll$str(), deploymentName);
    }
    protected String servletStackTracesAll$str() {
        return "UT015007: Stack trace on error enabled for deployment %s, please do not enable for production use";
    }
    @Override
    public final void failedtoLoadPersistentSessions(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedtoLoadPersistentSessions$str());
    }
    protected String failedtoLoadPersistentSessions$str() {
        return "UT015008: Failed to load development mode persistent sessions";
    }
    @Override
    public final void failedToPersistSessionAttribute(final String attributeName, final Object value, final String sessionID, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToPersistSessionAttribute$str(), attributeName, value, sessionID);
    }
    protected String failedToPersistSessionAttribute$str() {
        return "UT015009: Failed to persist session attribute %s with value %s for session %s";
    }
    @Override
    public final void failedToPersistSessions(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToPersistSessions$str());
    }
    protected String failedToPersistSessions$str() {
        return "UT015010: Failed to persist sessions";
    }
    @Override
    public final void errorGeneratingErrorPage(final String originalErrorPage, final Object originalException, final int code, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorGeneratingErrorPage$str(), originalErrorPage, originalException, code);
    }
    protected String errorGeneratingErrorPage$str() {
        return "UT015012: Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.";
    }
    @Override
    public final void errorReadingRewriteConfiguration(final IOException e) {
        super.log.logf(FQCN, ERROR, e, errorReadingRewriteConfiguration$str());
    }
    protected String errorReadingRewriteConfiguration$str() {
        return "UT015014: Error reading rewrite configuration";
    }
    protected String invalidRewriteConfiguration$str() {
        return "UT015015: Error reading rewrite configuration: %s";
    }
    @Override
    public final IllegalArgumentException invalidRewriteConfiguration(final String line) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRewriteConfiguration$str(), line));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidRewriteMap$str() {
        return "UT015016: Invalid rewrite map class: %s";
    }
    @Override
    public final IllegalArgumentException invalidRewriteMap(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRewriteMap$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRewriteFlags2$str() {
        return "UT015017: Error reading rewrite flags in line %s as %s";
    }
    @Override
    public final IllegalArgumentException invalidRewriteFlags(final String line, final String flags) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRewriteFlags2$str(), line, flags));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRewriteFlags1$str() {
        return "UT015018: Error reading rewrite flags in line %s";
    }
    @Override
    public final IllegalArgumentException invalidRewriteFlags(final String line) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRewriteFlags1$str(), line));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToDestroy(final Object object, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedToDestroy$str(), object);
    }
    protected String failedToDestroy$str() {
        return "UT015019: Failed to destroy %s";
    }
    @Override
    public final void unsecuredMethodsOnPath(final String path, final Set<String> missing) {
        super.log.logf(FQCN, WARN, null, unsecuredMethodsOnPath$str(), path, missing);
    }
    protected String unsecuredMethodsOnPath$str() {
        return "UT015020: Path %s is secured for some HTTP methods, however it is not secured for %s";
    }
    @Override
    public final void failureDispatchingAsyncEvent(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failureDispatchingAsyncEvent$str());
    }
    protected String failureDispatchingAsyncEvent$str() {
        return "UT015021: Failure dispatching async event";
    }
    @Override
    public final void requestedResourceDoesNotExistForIncludeMethod(final String path) {
        super.log.logf(FQCN, WARN, null, requestedResourceDoesNotExistForIncludeMethod$str(), path);
    }
    protected String requestedResourceDoesNotExistForIncludeMethod$str() {
        return "UT015022: Requested resource at %s does not exist for include method";
    }
}
