/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.BadRequestException;
import io.undertow.util.ParameterLimitException;
import java.util.Deque;
import java.util.Map;
import javax.servlet.ServletException;

public final class DispatchUtils {
    private DispatchUtils() {
    }

    public static ServletPathMatch dispatchForward(String path, HttpServletRequestImpl requestImpl, HttpServletResponseImpl responseImpl, ServletContextImpl servletContext) throws ParameterLimitException, BadRequestException {
        if (requestImpl.getAttribute("javax.servlet.forward.request_uri") == null) {
            requestImpl.setAttribute("javax.servlet.forward.request_uri", requestImpl.getRequestURI());
            requestImpl.setAttribute("javax.servlet.forward.context_path", requestImpl.getContextPath());
            requestImpl.setAttribute("javax.servlet.forward.servlet_path", requestImpl.getServletPath());
            requestImpl.setAttribute("javax.servlet.forward.path_info", requestImpl.getPathInfo());
            requestImpl.setAttribute("javax.servlet.forward.query_string", requestImpl.getQueryString());
            requestImpl.setAttribute("javax.servlet.forward.mapping", requestImpl.getHttpServletMapping());
        }
        String newRequestPath = DispatchUtils.assignRequestPath(path, requestImpl, servletContext, false);
        ServletPathMatch pathMatch = servletContext.getDeployment().getServletPaths().getServletHandlerByPath(newRequestPath);
        ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(pathMatch);
        requestImpl.setServletContext(servletContext);
        responseImpl.setServletContext(servletContext);
        return pathMatch;
    }

    public static ServletPathMatch dispatchInclude(String path, HttpServletRequestImpl requestImpl, HttpServletResponseImpl responseImpl, ServletContextImpl servletContext) throws ParameterLimitException, BadRequestException {
        String newRequestPath = DispatchUtils.assignRequestPath(path, requestImpl, servletContext, true);
        ServletPathMatch pathMatch = servletContext.getDeployment().getServletPaths().getServletHandlerByPath(newRequestPath);
        requestImpl.setAttribute("javax.servlet.include.context_path", servletContext.getContextPath());
        requestImpl.setAttribute("javax.servlet.include.servlet_path", pathMatch.getMatched());
        requestImpl.setAttribute("javax.servlet.include.path_info", pathMatch.getRemaining());
        requestImpl.setAttribute("javax.servlet.include.mapping", requestImpl.getHttpServletMapping());
        return pathMatch;
    }

    public static ServletPathMatch dispatchError(String path, String servletName, Throwable exception, String message, HttpServletRequestImpl requestImpl, HttpServletResponseImpl responseImpl, ServletContextImpl servletContext) throws ParameterLimitException, BadRequestException {
        if (requestImpl.getAttribute("javax.servlet.forward.request_uri") == null) {
            requestImpl.setAttribute("javax.servlet.forward.request_uri", requestImpl.getRequestURI());
            requestImpl.setAttribute("javax.servlet.forward.context_path", requestImpl.getContextPath());
            requestImpl.setAttribute("javax.servlet.forward.servlet_path", requestImpl.getServletPath());
            requestImpl.setAttribute("javax.servlet.forward.path_info", requestImpl.getPathInfo());
            requestImpl.setAttribute("javax.servlet.forward.query_string", requestImpl.getQueryString());
            requestImpl.setAttribute("javax.servlet.forward.mapping", requestImpl.getHttpServletMapping());
        }
        requestImpl.setAttribute("javax.servlet.error.request_uri", requestImpl.getRequestURI());
        requestImpl.setAttribute("javax.servlet.error.servlet_name", servletName);
        if (exception != null) {
            if (exception instanceof ServletException && ((ServletException)exception).getRootCause() != null) {
                requestImpl.setAttribute("javax.servlet.error.exception", ((ServletException)exception).getRootCause());
                requestImpl.setAttribute("javax.servlet.error.exception_type", ((ServletException)exception).getRootCause().getClass());
            } else {
                requestImpl.setAttribute("javax.servlet.error.exception", exception);
                requestImpl.setAttribute("javax.servlet.error.exception_type", exception.getClass());
            }
        }
        requestImpl.setAttribute("javax.servlet.error.message", message);
        requestImpl.setAttribute("javax.servlet.error.status_code", responseImpl.getStatus());
        String newRequestPath = DispatchUtils.assignRequestPath(path, requestImpl, servletContext, false);
        ServletPathMatch pathMatch = servletContext.getDeployment().getServletPaths().getServletHandlerByPath(newRequestPath);
        ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(pathMatch);
        requestImpl.setServletContext(servletContext);
        responseImpl.setServletContext(servletContext);
        return pathMatch;
    }

    public static ServletPathMatch dispatchAsync(String path, HttpServletRequestImpl requestImpl, HttpServletResponseImpl responseImpl, ServletContextImpl servletContext) throws ParameterLimitException, BadRequestException {
        requestImpl.setAttribute("javax.servlet.async.request_uri", requestImpl.getOriginalRequestURI());
        requestImpl.setAttribute("javax.servlet.async.context_path", requestImpl.getOriginalContextPath());
        requestImpl.setAttribute("javax.servlet.async.servlet_path", requestImpl.getOriginalServletPath());
        requestImpl.setAttribute("javax.servlet.async.path_info", requestImpl.getOriginalPathInfo());
        requestImpl.setAttribute("javax.servlet.async.query_string", requestImpl.getOriginalQueryString());
        requestImpl.setAttribute("javax.servlet.async.mapping", requestImpl.getHttpServletMapping());
        String newRequestPath = DispatchUtils.assignRequestPath(path, requestImpl, servletContext, false);
        ServletPathMatch pathMatch = servletContext.getDeployment().getServletPaths().getServletHandlerByPath(newRequestPath);
        ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(pathMatch);
        requestImpl.setServletContext(servletContext);
        responseImpl.setServletContext(servletContext);
        return pathMatch;
    }

    private static Map<String, Deque<String>> mergeQueryParameters(Map<String, Deque<String>> newParams, Map<String, Deque<String>> oldParams) {
        for (Map.Entry<String, Deque<String>> entry : oldParams.entrySet()) {
            Deque<String> values = newParams.get(entry.getKey());
            if (values == null) {
                newParams.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (String v : entry.getValue()) {
                if (values.contains(v)) continue;
                values.add(v);
            }
        }
        return newParams;
    }

    private static String assignRequestPath(String path, HttpServletRequestImpl requestImpl, ServletContextImpl servletContext, boolean include) throws ParameterLimitException, BadRequestException {
        StringBuilder sb = new StringBuilder();
        HttpServerExchange exchange = requestImpl.getExchange();
        HttpServerExchange fake = new HttpServerExchange(exchange.getConnection(), exchange.getRequestHeaders(), exchange.getResponseHeaders(), exchange.getMaxEntitySize());
        Connectors.setExchangeRequestPath((HttpServerExchange)fake, (String)(servletContext.getContextPath() + path), (StringBuilder)sb);
        String newRequestPath = fake.getRequestPath().substring(servletContext.getContextPath().length());
        if (include) {
            requestImpl.setAttribute("javax.servlet.include.query_string", fake.getQueryString());
            requestImpl.setAttribute("javax.servlet.include.request_uri", fake.getRequestURI());
        } else {
            exchange.setRelativePath(newRequestPath);
            exchange.setRequestPath(fake.getRequestPath());
            exchange.setRequestURI(fake.getRequestURI());
            if (!fake.getQueryString().isEmpty()) {
                exchange.setQueryString(fake.getQueryString());
            }
        }
        if (!fake.getQueryString().isEmpty()) {
            requestImpl.setQueryParameters(DispatchUtils.mergeQueryParameters(fake.getQueryParameters(), requestImpl.getQueryParameters()));
        }
        return newRequestPath;
    }
}

