package io.undertow.websockets.jsr;

import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import javax.websocket.server.PathParam;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-09-16T15:24:26+1000")
public class JsrWebSocketLogger_$logger extends DelegatingBasicLogger implements JsrWebSocketLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JsrWebSocketLogger_$logger.class.getName();
    public JsrWebSocketLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void endpointCreationFailed(final Exception cause) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, endpointCreationFailed$str());
    }
    private static final String endpointCreationFailed = "UT026001: Unable to instantiate endpoint";
    protected String endpointCreationFailed$str() {
        return endpointCreationFailed;
    }
    @Override
    public final void couldNotInitializeConfiguration(final Class<? extends Object> clazz, final Throwable t) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, t, couldNotInitializeConfiguration$str(), clazz);
    }
    private static final String couldNotInitializeConfiguration = "UT026002: Unable to instantiate server configuration %s";
    protected String couldNotInitializeConfiguration$str() {
        return couldNotInitializeConfiguration;
    }
    @Override
    public final void addingAnnotatedServerEndpoint(final Class<? extends Object> endpoint, final String value) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, addingAnnotatedServerEndpoint$str(), endpoint, value);
    }
    private static final String addingAnnotatedServerEndpoint = "UT026003: Adding annotated server endpoint %s for path %s";
    protected String addingAnnotatedServerEndpoint$str() {
        return addingAnnotatedServerEndpoint;
    }
    @Override
    public final void addingAnnotatedClientEndpoint(final Class<? extends Object> endpoint) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, addingAnnotatedClientEndpoint$str(), endpoint);
    }
    private static final String addingAnnotatedClientEndpoint = "UT026004: Adding annotated client endpoint %s";
    protected String addingAnnotatedClientEndpoint$str() {
        return addingAnnotatedClientEndpoint;
    }
    @Override
    public final void addingProgramaticEndpoint(final Class<? extends Object> endpointClass, final String path) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, addingProgramaticEndpoint$str(), endpointClass, path);
    }
    private static final String addingProgramaticEndpoint = "UT026005: Adding programmatic server endpoint %s for path %s";
    protected String addingProgramaticEndpoint$str() {
        return addingProgramaticEndpoint;
    }
    @Override
    public final void exceptionInWebSocketMethod(final Throwable e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, exceptionInWebSocketMethod$str());
    }
    private static final String exceptionInWebSocketMethod = "UT026006: Exception running web socket method";
    protected String exceptionInWebSocketMethod$str() {
        return exceptionInWebSocketMethod;
    }
    @Override
    public final void pathTemplateNotFound(final Class<? extends Object> endpointClass, final PathParam param, final Method method, final Set<String> paths) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, pathTemplateNotFound$str(), endpointClass, param, method, paths);
    }
    private static final String pathTemplateNotFound = "UT026007: On Endpoint class %s path param %s on method %s does not reference a valid parameter, valid parameters are %s.";
    protected String pathTemplateNotFound$str() {
        return pathTemplateNotFound;
    }
    @Override
    public final void couldNotCloseOnUndeploy(final Exception e) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, couldNotCloseOnUndeploy$str());
    }
    private static final String couldNotCloseOnUndeploy = "UT026008: Could not close endpoint on undeploy.";
    protected String couldNotCloseOnUndeploy$str() {
        return couldNotCloseOnUndeploy;
    }
    @Override
    public final void xnioWorkerWasNull() {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, xnioWorkerWasNull$str());
    }
    private static final String xnioWorkerWasNull = "UT026009: XNIO worker was not set on WebSocketDeploymentInfo, the default worker will be used";
    protected String xnioWorkerWasNull$str() {
        return xnioWorkerWasNull;
    }
    @Override
    public final void bufferPoolWasNull() {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, bufferPoolWasNull$str());
    }
    private static final String bufferPoolWasNull = "UT026010: Buffer pool was not set on WebSocketDeploymentInfo, the default pool will be used";
    protected String bufferPoolWasNull$str() {
        return bufferPoolWasNull;
    }
    private static final String xnioWorkerWasNullAndNoDefault = "UT026011: XNIO worker was not set on WebSocketDeploymentInfo, and there is no default to use";
    protected String xnioWorkerWasNullAndNoDefault$str() {
        return xnioWorkerWasNullAndNoDefault;
    }
    @Override
    public final IllegalArgumentException xnioWorkerWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(xnioWorkerWasNullAndNoDefault$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bufferPoolWasNullAndNoDefault = "UT026012: Buffer pool was not set on WebSocketDeploymentInfo, and there is no default to use";
    protected String bufferPoolWasNullAndNoDefault$str() {
        return bufferPoolWasNullAndNoDefault;
    }
    @Override
    public final IllegalArgumentException bufferPoolWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(bufferPoolWasNullAndNoDefault$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
