/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.ApiException;
import io.unitycatalog.client.ApiResponse;
import io.unitycatalog.client.Pair;
import io.unitycatalog.client.model.CreateVolumeRequestContent;
import io.unitycatalog.client.model.ListVolumesResponseContent;
import io.unitycatalog.client.model.UpdateVolumeRequestContent;
import io.unitycatalog.client.model.VolumeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class VolumesApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public VolumesApi() {
        this(new ApiClient());
    }

    public VolumesApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public VolumeInfo createVolume(CreateVolumeRequestContent createVolumeRequestContent) throws ApiException {
        ApiResponse<VolumeInfo> localVarResponse = this.createVolumeWithHttpInfo(createVolumeRequestContent);
        return localVarResponse.getData();
    }

    public ApiResponse<VolumeInfo> createVolumeWithHttpInfo(CreateVolumeRequestContent createVolumeRequestContent) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createVolumeRequestBuilder(createVolumeRequestContent);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createVolume", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (VolumeInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<VolumeInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createVolumeRequestBuilder(CreateVolumeRequestContent createVolumeRequestContent) throws ApiException {
        if (createVolumeRequestContent == null) {
            throw new ApiException(400, "Missing the required parameter 'createVolumeRequestContent' when calling createVolume");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/volumes";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createVolumeRequestContent);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Object deleteVolume(String name) throws ApiException {
        ApiResponse<Object> localVarResponse = this.deleteVolumeWithHttpInfo(name);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> deleteVolumeWithHttpInfo(String name) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.deleteVolumeRequestBuilder(name);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteVolume", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Object>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder deleteVolumeRequestBuilder(String name) throws ApiException {
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling deleteVolume");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/volumes/{name}".replace("{name}", ApiClient.urlEncode(name.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public VolumeInfo getVolume(String name) throws ApiException {
        ApiResponse<VolumeInfo> localVarResponse = this.getVolumeWithHttpInfo(name);
        return localVarResponse.getData();
    }

    public ApiResponse<VolumeInfo> getVolumeWithHttpInfo(String name) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getVolumeRequestBuilder(name);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getVolume", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (VolumeInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<VolumeInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getVolumeRequestBuilder(String name) throws ApiException {
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling getVolume");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/volumes/{name}".replace("{name}", ApiClient.urlEncode(name.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ListVolumesResponseContent listVolumes(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        ApiResponse<ListVolumesResponseContent> localVarResponse = this.listVolumesWithHttpInfo(catalogName, schemaName, maxResults, pageToken);
        return localVarResponse.getData();
    }

    public ApiResponse<ListVolumesResponseContent> listVolumesWithHttpInfo(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listVolumesRequestBuilder(catalogName, schemaName, maxResults, pageToken);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listVolumes", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ListVolumesResponseContent)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ListVolumesResponseContent>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listVolumesRequestBuilder(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        if (catalogName == null) {
            throw new ApiException(400, "Missing the required parameter 'catalogName' when calling listVolumes");
        }
        if (schemaName == null) {
            throw new ApiException(400, "Missing the required parameter 'schemaName' when calling listVolumes");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/volumes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "catalog_name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("catalog_name", catalogName));
        localVarQueryParameterBaseName = "schema_name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("schema_name", schemaName));
        localVarQueryParameterBaseName = "max_results";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("max_results", maxResults));
        localVarQueryParameterBaseName = "page_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_token", pageToken));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public VolumeInfo updateVolume(String name, UpdateVolumeRequestContent updateVolumeRequestContent) throws ApiException {
        ApiResponse<VolumeInfo> localVarResponse = this.updateVolumeWithHttpInfo(name, updateVolumeRequestContent);
        return localVarResponse.getData();
    }

    public ApiResponse<VolumeInfo> updateVolumeWithHttpInfo(String name, UpdateVolumeRequestContent updateVolumeRequestContent) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateVolumeRequestBuilder(name, updateVolumeRequestContent);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateVolume", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (VolumeInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<VolumeInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateVolumeRequestBuilder(String name, UpdateVolumeRequestContent updateVolumeRequestContent) throws ApiException {
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling updateVolume");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/volumes/{name}".replace("{name}", ApiClient.urlEncode(name.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateVolumeRequestContent);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

