/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.unitycatalog.client.model.ColumnTypeName;
import io.unitycatalog.client.model.DependencyList;
import io.unitycatalog.client.model.FunctionParameterInfos;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "catalog_name", "schema_name", "input_params", "data_type", "full_data_type", "return_params", "routine_body", "routine_definition", "routine_dependencies", "parameter_style", "is_deterministic", "sql_data_access", "is_null_call", "security_type", "specific_name", "comment", "properties", "external_language"})
public class CreateFunction {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CATALOG_NAME = "catalog_name";
    private String catalogName;
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schema_name";
    private String schemaName;
    public static final String JSON_PROPERTY_INPUT_PARAMS = "input_params";
    private FunctionParameterInfos inputParams;
    public static final String JSON_PROPERTY_DATA_TYPE = "data_type";
    private ColumnTypeName dataType;
    public static final String JSON_PROPERTY_FULL_DATA_TYPE = "full_data_type";
    private String fullDataType;
    public static final String JSON_PROPERTY_RETURN_PARAMS = "return_params";
    private FunctionParameterInfos returnParams;
    public static final String JSON_PROPERTY_ROUTINE_BODY = "routine_body";
    private RoutineBodyEnum routineBody;
    public static final String JSON_PROPERTY_ROUTINE_DEFINITION = "routine_definition";
    private String routineDefinition;
    public static final String JSON_PROPERTY_ROUTINE_DEPENDENCIES = "routine_dependencies";
    private DependencyList routineDependencies;
    public static final String JSON_PROPERTY_PARAMETER_STYLE = "parameter_style";
    private ParameterStyleEnum parameterStyle;
    public static final String JSON_PROPERTY_IS_DETERMINISTIC = "is_deterministic";
    private Boolean isDeterministic;
    public static final String JSON_PROPERTY_SQL_DATA_ACCESS = "sql_data_access";
    private SqlDataAccessEnum sqlDataAccess;
    public static final String JSON_PROPERTY_IS_NULL_CALL = "is_null_call";
    private Boolean isNullCall;
    public static final String JSON_PROPERTY_SECURITY_TYPE = "security_type";
    private SecurityTypeEnum securityType;
    public static final String JSON_PROPERTY_SPECIFIC_NAME = "specific_name";
    private String specificName;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private String properties;
    public static final String JSON_PROPERTY_EXTERNAL_LANGUAGE = "external_language";
    private String externalLanguage;

    public CreateFunction name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateFunction catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public CreateFunction schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public CreateFunction inputParams(FunctionParameterInfos inputParams) {
        this.inputParams = inputParams;
        return this;
    }

    @Nonnull
    @JsonProperty(value="input_params")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunctionParameterInfos getInputParams() {
        return this.inputParams;
    }

    @JsonProperty(value="input_params")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInputParams(FunctionParameterInfos inputParams) {
        this.inputParams = inputParams;
    }

    public CreateFunction dataType(ColumnTypeName dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="data_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ColumnTypeName getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="data_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataType(ColumnTypeName dataType) {
        this.dataType = dataType;
    }

    public CreateFunction fullDataType(String fullDataType) {
        this.fullDataType = fullDataType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="full_data_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFullDataType() {
        return this.fullDataType;
    }

    @JsonProperty(value="full_data_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFullDataType(String fullDataType) {
        this.fullDataType = fullDataType;
    }

    public CreateFunction returnParams(FunctionParameterInfos returnParams) {
        this.returnParams = returnParams;
        return this;
    }

    @Nullable
    @JsonProperty(value="return_params")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FunctionParameterInfos getReturnParams() {
        return this.returnParams;
    }

    @JsonProperty(value="return_params")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnParams(FunctionParameterInfos returnParams) {
        this.returnParams = returnParams;
    }

    public CreateFunction routineBody(RoutineBodyEnum routineBody) {
        this.routineBody = routineBody;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routine_body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoutineBodyEnum getRoutineBody() {
        return this.routineBody;
    }

    @JsonProperty(value="routine_body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutineBody(RoutineBodyEnum routineBody) {
        this.routineBody = routineBody;
    }

    public CreateFunction routineDefinition(String routineDefinition) {
        this.routineDefinition = routineDefinition;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routine_definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoutineDefinition() {
        return this.routineDefinition;
    }

    @JsonProperty(value="routine_definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutineDefinition(String routineDefinition) {
        this.routineDefinition = routineDefinition;
    }

    public CreateFunction routineDependencies(DependencyList routineDependencies) {
        this.routineDependencies = routineDependencies;
        return this;
    }

    @Nullable
    @JsonProperty(value="routine_dependencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DependencyList getRoutineDependencies() {
        return this.routineDependencies;
    }

    @JsonProperty(value="routine_dependencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutineDependencies(DependencyList routineDependencies) {
        this.routineDependencies = routineDependencies;
    }

    public CreateFunction parameterStyle(ParameterStyleEnum parameterStyle) {
        this.parameterStyle = parameterStyle;
        return this;
    }

    @Nonnull
    @JsonProperty(value="parameter_style")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParameterStyleEnum getParameterStyle() {
        return this.parameterStyle;
    }

    @JsonProperty(value="parameter_style")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParameterStyle(ParameterStyleEnum parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public CreateFunction isDeterministic(Boolean isDeterministic) {
        this.isDeterministic = isDeterministic;
        return this;
    }

    @Nonnull
    @JsonProperty(value="is_deterministic")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsDeterministic() {
        return this.isDeterministic;
    }

    @JsonProperty(value="is_deterministic")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsDeterministic(Boolean isDeterministic) {
        this.isDeterministic = isDeterministic;
    }

    public CreateFunction sqlDataAccess(SqlDataAccessEnum sqlDataAccess) {
        this.sqlDataAccess = sqlDataAccess;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sql_data_access")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SqlDataAccessEnum getSqlDataAccess() {
        return this.sqlDataAccess;
    }

    @JsonProperty(value="sql_data_access")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSqlDataAccess(SqlDataAccessEnum sqlDataAccess) {
        this.sqlDataAccess = sqlDataAccess;
    }

    public CreateFunction isNullCall(Boolean isNullCall) {
        this.isNullCall = isNullCall;
        return this;
    }

    @Nonnull
    @JsonProperty(value="is_null_call")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsNullCall() {
        return this.isNullCall;
    }

    @JsonProperty(value="is_null_call")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsNullCall(Boolean isNullCall) {
        this.isNullCall = isNullCall;
    }

    public CreateFunction securityType(SecurityTypeEnum securityType) {
        this.securityType = securityType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="security_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityTypeEnum getSecurityType() {
        return this.securityType;
    }

    @JsonProperty(value="security_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecurityType(SecurityTypeEnum securityType) {
        this.securityType = securityType;
    }

    public CreateFunction specificName(String specificName) {
        this.specificName = specificName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="specific_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSpecificName() {
        return this.specificName;
    }

    @JsonProperty(value="specific_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    public CreateFunction comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateFunction properties(String properties) {
        this.properties = properties;
        return this;
    }

    @Nonnull
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProperties(String properties) {
        this.properties = properties;
    }

    public CreateFunction externalLanguage(String externalLanguage) {
        this.externalLanguage = externalLanguage;
        return this;
    }

    @Nullable
    @JsonProperty(value="external_language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalLanguage() {
        return this.externalLanguage;
    }

    @JsonProperty(value="external_language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalLanguage(String externalLanguage) {
        this.externalLanguage = externalLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFunction createFunction = (CreateFunction)o;
        return Objects.equals(this.name, createFunction.name) && Objects.equals(this.catalogName, createFunction.catalogName) && Objects.equals(this.schemaName, createFunction.schemaName) && Objects.equals(this.inputParams, createFunction.inputParams) && Objects.equals((Object)this.dataType, (Object)createFunction.dataType) && Objects.equals(this.fullDataType, createFunction.fullDataType) && Objects.equals(this.returnParams, createFunction.returnParams) && Objects.equals((Object)this.routineBody, (Object)createFunction.routineBody) && Objects.equals(this.routineDefinition, createFunction.routineDefinition) && Objects.equals(this.routineDependencies, createFunction.routineDependencies) && Objects.equals((Object)this.parameterStyle, (Object)createFunction.parameterStyle) && Objects.equals(this.isDeterministic, createFunction.isDeterministic) && Objects.equals((Object)this.sqlDataAccess, (Object)createFunction.sqlDataAccess) && Objects.equals(this.isNullCall, createFunction.isNullCall) && Objects.equals((Object)this.securityType, (Object)createFunction.securityType) && Objects.equals(this.specificName, createFunction.specificName) && Objects.equals(this.comment, createFunction.comment) && Objects.equals(this.properties, createFunction.properties) && Objects.equals(this.externalLanguage, createFunction.externalLanguage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.catalogName, this.schemaName, this.inputParams, this.dataType, this.fullDataType, this.returnParams, this.routineBody, this.routineDefinition, this.routineDependencies, this.parameterStyle, this.isDeterministic, this.sqlDataAccess, this.isNullCall, this.securityType, this.specificName, this.comment, this.properties, this.externalLanguage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFunction {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    catalogName: ").append(this.toIndentedString(this.catalogName)).append("\n");
        sb.append("    schemaName: ").append(this.toIndentedString(this.schemaName)).append("\n");
        sb.append("    inputParams: ").append(this.toIndentedString(this.inputParams)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    fullDataType: ").append(this.toIndentedString(this.fullDataType)).append("\n");
        sb.append("    returnParams: ").append(this.toIndentedString(this.returnParams)).append("\n");
        sb.append("    routineBody: ").append(this.toIndentedString((Object)this.routineBody)).append("\n");
        sb.append("    routineDefinition: ").append(this.toIndentedString(this.routineDefinition)).append("\n");
        sb.append("    routineDependencies: ").append(this.toIndentedString(this.routineDependencies)).append("\n");
        sb.append("    parameterStyle: ").append(this.toIndentedString((Object)this.parameterStyle)).append("\n");
        sb.append("    isDeterministic: ").append(this.toIndentedString(this.isDeterministic)).append("\n");
        sb.append("    sqlDataAccess: ").append(this.toIndentedString((Object)this.sqlDataAccess)).append("\n");
        sb.append("    isNullCall: ").append(this.toIndentedString(this.isNullCall)).append("\n");
        sb.append("    securityType: ").append(this.toIndentedString((Object)this.securityType)).append("\n");
        sb.append("    specificName: ").append(this.toIndentedString(this.specificName)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    externalLanguage: ").append(this.toIndentedString(this.externalLanguage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCatalogName() != null) {
            joiner.add(String.format("%scatalog_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCatalogName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSchemaName() != null) {
            joiner.add(String.format("%sschema_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSchemaName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInputParams() != null) {
            joiner.add(this.getInputParams().toUrlQueryString((String)prefix + JSON_PROPERTY_INPUT_PARAMS + suffix));
        }
        if (this.getDataType() != null) {
            joiner.add(String.format("%sdata_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDataType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFullDataType() != null) {
            joiner.add(String.format("%sfull_data_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFullDataType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getReturnParams() != null) {
            joiner.add(this.getReturnParams().toUrlQueryString((String)prefix + JSON_PROPERTY_RETURN_PARAMS + suffix));
        }
        if (this.getRoutineBody() != null) {
            joiner.add(String.format("%sroutine_body%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRoutineBody()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutineDefinition() != null) {
            joiner.add(String.format("%sroutine_definition%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoutineDefinition()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutineDependencies() != null) {
            joiner.add(this.getRoutineDependencies().toUrlQueryString((String)prefix + JSON_PROPERTY_ROUTINE_DEPENDENCIES + suffix));
        }
        if (this.getParameterStyle() != null) {
            joiner.add(String.format("%sparameter_style%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getParameterStyle()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIsDeterministic() != null) {
            joiner.add(String.format("%sis_deterministic%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsDeterministic()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSqlDataAccess() != null) {
            joiner.add(String.format("%ssql_data_access%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSqlDataAccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIsNullCall() != null) {
            joiner.add(String.format("%sis_null_call%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsNullCall()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSecurityType() != null) {
            joiner.add(String.format("%ssecurity_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSecurityType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSpecificName() != null) {
            joiner.add(String.format("%sspecific_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSpecificName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProperties() != null) {
            joiner.add(String.format("%sproperties%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProperties()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExternalLanguage() != null) {
            joiner.add(String.format("%sexternal_language%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExternalLanguage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum RoutineBodyEnum {
        SQL("SQL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private RoutineBodyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoutineBodyEnum fromValue(String value) {
            for (RoutineBodyEnum b : RoutineBodyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ParameterStyleEnum {
        S("S");

        private String value;

        private ParameterStyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParameterStyleEnum fromValue(String value) {
            for (ParameterStyleEnum b : ParameterStyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SqlDataAccessEnum {
        CONTAINS_SQL("CONTAINS_SQL"),
        READS_SQL_DATA("READS_SQL_DATA"),
        NO_SQL("NO_SQL");

        private String value;

        private SqlDataAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SqlDataAccessEnum fromValue(String value) {
            for (SqlDataAccessEnum b : SqlDataAccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SecurityTypeEnum {
        DEFINER("DEFINER");

        private String value;

        private SecurityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SecurityTypeEnum fromValue(String value) {
            for (SecurityTypeEnum b : SecurityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

