/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.model.FunctionDependency;
import io.unitycatalog.client.model.TableDependency;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"table", "function"})
public class Dependency {
    public static final String JSON_PROPERTY_TABLE = "table";
    private TableDependency table;
    public static final String JSON_PROPERTY_FUNCTION = "function";
    private FunctionDependency function;

    public Dependency table(TableDependency table) {
        this.table = table;
        return this;
    }

    @Nullable
    @JsonProperty(value="table")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableDependency getTable() {
        return this.table;
    }

    @JsonProperty(value="table")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTable(TableDependency table) {
        this.table = table;
    }

    public Dependency function(FunctionDependency function) {
        this.function = function;
        return this;
    }

    @Nullable
    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FunctionDependency getFunction() {
        return this.function;
    }

    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFunction(FunctionDependency function) {
        this.function = function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency dependency = (Dependency)o;
        return Objects.equals(this.table, dependency.table) && Objects.equals(this.function, dependency.function);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.function);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dependency {\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTable() != null) {
            joiner.add(this.getTable().toUrlQueryString((String)prefix + JSON_PROPERTY_TABLE + suffix));
        }
        if (this.getFunction() != null) {
            joiner.add(this.getFunction().toUrlQueryString((String)prefix + JSON_PROPERTY_FUNCTION + suffix));
        }
        return joiner.toString();
    }
}

