/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.model.ColumnTypeName;
import io.unitycatalog.client.model.FunctionParameterMode;
import io.unitycatalog.client.model.FunctionParameterType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "type_text", "type_json", "type_name", "type_precision", "type_scale", "type_interval_type", "position", "parameter_mode", "parameter_type", "parameter_default", "comment"})
public class FunctionParameterInfo {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE_TEXT = "type_text";
    private String typeText;
    public static final String JSON_PROPERTY_TYPE_JSON = "type_json";
    private String typeJson;
    public static final String JSON_PROPERTY_TYPE_NAME = "type_name";
    private ColumnTypeName typeName;
    public static final String JSON_PROPERTY_TYPE_PRECISION = "type_precision";
    private Integer typePrecision;
    public static final String JSON_PROPERTY_TYPE_SCALE = "type_scale";
    private Integer typeScale;
    public static final String JSON_PROPERTY_TYPE_INTERVAL_TYPE = "type_interval_type";
    private String typeIntervalType;
    public static final String JSON_PROPERTY_POSITION = "position";
    private Integer position;
    public static final String JSON_PROPERTY_PARAMETER_MODE = "parameter_mode";
    private FunctionParameterMode parameterMode;
    public static final String JSON_PROPERTY_PARAMETER_TYPE = "parameter_type";
    private FunctionParameterType parameterType;
    public static final String JSON_PROPERTY_PARAMETER_DEFAULT = "parameter_default";
    private String parameterDefault;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;

    public FunctionParameterInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public FunctionParameterInfo typeText(String typeText) {
        this.typeText = typeText;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type_text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTypeText() {
        return this.typeText;
    }

    @JsonProperty(value="type_text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    public FunctionParameterInfo typeJson(String typeJson) {
        this.typeJson = typeJson;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type_json")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTypeJson() {
        return this.typeJson;
    }

    @JsonProperty(value="type_json")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeJson(String typeJson) {
        this.typeJson = typeJson;
    }

    public FunctionParameterInfo typeName(ColumnTypeName typeName) {
        this.typeName = typeName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ColumnTypeName getTypeName() {
        return this.typeName;
    }

    @JsonProperty(value="type_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeName(ColumnTypeName typeName) {
        this.typeName = typeName;
    }

    public FunctionParameterInfo typePrecision(Integer typePrecision) {
        this.typePrecision = typePrecision;
        return this;
    }

    @Nullable
    @JsonProperty(value="type_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTypePrecision() {
        return this.typePrecision;
    }

    @JsonProperty(value="type_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypePrecision(Integer typePrecision) {
        this.typePrecision = typePrecision;
    }

    public FunctionParameterInfo typeScale(Integer typeScale) {
        this.typeScale = typeScale;
        return this;
    }

    @Nullable
    @JsonProperty(value="type_scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTypeScale() {
        return this.typeScale;
    }

    @JsonProperty(value="type_scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypeScale(Integer typeScale) {
        this.typeScale = typeScale;
    }

    public FunctionParameterInfo typeIntervalType(String typeIntervalType) {
        this.typeIntervalType = typeIntervalType;
        return this;
    }

    @Nullable
    @JsonProperty(value="type_interval_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTypeIntervalType() {
        return this.typeIntervalType;
    }

    @JsonProperty(value="type_interval_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypeIntervalType(String typeIntervalType) {
        this.typeIntervalType = typeIntervalType;
    }

    public FunctionParameterInfo position(Integer position) {
        this.position = position;
        return this;
    }

    @Nonnull
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPosition(Integer position) {
        this.position = position;
    }

    public FunctionParameterInfo parameterMode(FunctionParameterMode parameterMode) {
        this.parameterMode = parameterMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameter_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FunctionParameterMode getParameterMode() {
        return this.parameterMode;
    }

    @JsonProperty(value="parameter_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterMode(FunctionParameterMode parameterMode) {
        this.parameterMode = parameterMode;
    }

    public FunctionParameterInfo parameterType(FunctionParameterType parameterType) {
        this.parameterType = parameterType;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameter_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FunctionParameterType getParameterType() {
        return this.parameterType;
    }

    @JsonProperty(value="parameter_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterType(FunctionParameterType parameterType) {
        this.parameterType = parameterType;
    }

    public FunctionParameterInfo parameterDefault(String parameterDefault) {
        this.parameterDefault = parameterDefault;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameter_default")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParameterDefault() {
        return this.parameterDefault;
    }

    @JsonProperty(value="parameter_default")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterDefault(String parameterDefault) {
        this.parameterDefault = parameterDefault;
    }

    public FunctionParameterInfo comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionParameterInfo functionParameterInfo = (FunctionParameterInfo)o;
        return Objects.equals(this.name, functionParameterInfo.name) && Objects.equals(this.typeText, functionParameterInfo.typeText) && Objects.equals(this.typeJson, functionParameterInfo.typeJson) && Objects.equals((Object)this.typeName, (Object)functionParameterInfo.typeName) && Objects.equals(this.typePrecision, functionParameterInfo.typePrecision) && Objects.equals(this.typeScale, functionParameterInfo.typeScale) && Objects.equals(this.typeIntervalType, functionParameterInfo.typeIntervalType) && Objects.equals(this.position, functionParameterInfo.position) && Objects.equals((Object)this.parameterMode, (Object)functionParameterInfo.parameterMode) && Objects.equals((Object)this.parameterType, (Object)functionParameterInfo.parameterType) && Objects.equals(this.parameterDefault, functionParameterInfo.parameterDefault) && Objects.equals(this.comment, functionParameterInfo.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.typeText, this.typeJson, this.typeName, this.typePrecision, this.typeScale, this.typeIntervalType, this.position, this.parameterMode, this.parameterType, this.parameterDefault, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionParameterInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    typeText: ").append(this.toIndentedString(this.typeText)).append("\n");
        sb.append("    typeJson: ").append(this.toIndentedString(this.typeJson)).append("\n");
        sb.append("    typeName: ").append(this.toIndentedString((Object)this.typeName)).append("\n");
        sb.append("    typePrecision: ").append(this.toIndentedString(this.typePrecision)).append("\n");
        sb.append("    typeScale: ").append(this.toIndentedString(this.typeScale)).append("\n");
        sb.append("    typeIntervalType: ").append(this.toIndentedString(this.typeIntervalType)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    parameterMode: ").append(this.toIndentedString((Object)this.parameterMode)).append("\n");
        sb.append("    parameterType: ").append(this.toIndentedString((Object)this.parameterType)).append("\n");
        sb.append("    parameterDefault: ").append(this.toIndentedString(this.parameterDefault)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypeText() != null) {
            joiner.add(String.format("%stype_text%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTypeText()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypeJson() != null) {
            joiner.add(String.format("%stype_json%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTypeJson()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypeName() != null) {
            joiner.add(String.format("%stype_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getTypeName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypePrecision() != null) {
            joiner.add(String.format("%stype_precision%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTypePrecision()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypeScale() != null) {
            joiner.add(String.format("%stype_scale%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTypeScale()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTypeIntervalType() != null) {
            joiner.add(String.format("%stype_interval_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTypeIntervalType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPosition() != null) {
            joiner.add(String.format("%sposition%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPosition()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getParameterMode() != null) {
            joiner.add(String.format("%sparameter_mode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getParameterMode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getParameterType() != null) {
            joiner.add(String.format("%sparameter_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getParameterType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getParameterDefault() != null) {
            joiner.add(String.format("%sparameter_default%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getParameterDefault()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

