/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.model.VolumeInfo;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"volumes", "next_page_token"})
public class ListVolumesResponseContent {
    public static final String JSON_PROPERTY_VOLUMES = "volumes";
    private List<VolumeInfo> volumes = new ArrayList<VolumeInfo>();
    public static final String JSON_PROPERTY_NEXT_PAGE_TOKEN = "next_page_token";
    private String nextPageToken;

    public ListVolumesResponseContent volumes(List<VolumeInfo> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ListVolumesResponseContent addVolumesItem(VolumeInfo volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeInfo>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="volumes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VolumeInfo> getVolumes() {
        return this.volumes;
    }

    @JsonProperty(value="volumes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVolumes(List<VolumeInfo> volumes) {
        this.volumes = volumes;
    }

    public ListVolumesResponseContent nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListVolumesResponseContent listVolumesResponseContent = (ListVolumesResponseContent)o;
        return Objects.equals(this.volumes, listVolumesResponseContent.volumes) && Objects.equals(this.nextPageToken, listVolumesResponseContent.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.volumes, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListVolumesResponseContent {\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVolumes() != null) {
            for (int i = 0; i < this.getVolumes().size(); ++i) {
                if (this.getVolumes().get(i) == null) continue;
                joiner.add(this.getVolumes().get(i).toUrlQueryString(String.format("%svolumes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getNextPageToken() != null) {
            joiner.add(String.format("%snext_page_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNextPageToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

